<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExceptionBoundaryProgram StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ExceptionBoundaryProgram
 * @subpackage Structs
 */
class ExceptionBoundaryProgram extends AbstractStructBase
{
    /**
     * The ExceptionBoundaryGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExceptionBoundaryGuid;
    /**
     * The ExceptionBoundaryID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExceptionBoundaryID;
    /**
     * The ExceptionBoundaryProgramGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExceptionBoundaryProgramGuid;
    /**
     * The Exclude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The ProgramGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProgramGuid;
    /**
     * Constructor method for ExceptionBoundaryProgram
     * @uses ExceptionBoundaryProgram::setExceptionBoundaryGuid()
     * @uses ExceptionBoundaryProgram::setExceptionBoundaryID()
     * @uses ExceptionBoundaryProgram::setExceptionBoundaryProgramGuid()
     * @uses ExceptionBoundaryProgram::setExclude()
     * @uses ExceptionBoundaryProgram::setID()
     * @uses ExceptionBoundaryProgram::setName()
     * @uses ExceptionBoundaryProgram::setProgramGuid()
     * @param string $exceptionBoundaryGuid
     * @param string $exceptionBoundaryID
     * @param string $exceptionBoundaryProgramGuid
     * @param bool $exclude
     * @param \StructType\BPID $iD
     * @param string $name
     * @param string $programGuid
     */
    public function __construct($exceptionBoundaryGuid = null, $exceptionBoundaryID = null, $exceptionBoundaryProgramGuid = null, $exclude = null, \StructType\BPID $iD = null, $name = null, $programGuid = null)
    {
        $this
            ->setExceptionBoundaryGuid($exceptionBoundaryGuid)
            ->setExceptionBoundaryID($exceptionBoundaryID)
            ->setExceptionBoundaryProgramGuid($exceptionBoundaryProgramGuid)
            ->setExclude($exclude)
            ->setID($iD)
            ->setName($name)
            ->setProgramGuid($programGuid);
    }
    /**
     * Get ExceptionBoundaryGuid value
     * @return string|null
     */
    public function getExceptionBoundaryGuid()
    {
        return $this->ExceptionBoundaryGuid;
    }
    /**
     * Set ExceptionBoundaryGuid value
     * @param string $exceptionBoundaryGuid
     * @return \StructType\ExceptionBoundaryProgram
     */
    public function setExceptionBoundaryGuid($exceptionBoundaryGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($exceptionBoundaryGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $exceptionBoundaryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($exceptionBoundaryGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($exceptionBoundaryGuid) && !is_string($exceptionBoundaryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionBoundaryGuid)), __LINE__);
        }
        $this->ExceptionBoundaryGuid = $exceptionBoundaryGuid;
        return $this;
    }
    /**
     * Get ExceptionBoundaryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExceptionBoundaryID()
    {
        return isset($this->ExceptionBoundaryID) ? $this->ExceptionBoundaryID : null;
    }
    /**
     * Set ExceptionBoundaryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exceptionBoundaryID
     * @return \StructType\ExceptionBoundaryProgram
     */
    public function setExceptionBoundaryID($exceptionBoundaryID = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionBoundaryID) && !is_string($exceptionBoundaryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionBoundaryID)), __LINE__);
        }
        if (is_null($exceptionBoundaryID) || (is_array($exceptionBoundaryID) && empty($exceptionBoundaryID))) {
            unset($this->ExceptionBoundaryID);
        } else {
            $this->ExceptionBoundaryID = $exceptionBoundaryID;
        }
        return $this;
    }
    /**
     * Get ExceptionBoundaryProgramGuid value
     * @return string|null
     */
    public function getExceptionBoundaryProgramGuid()
    {
        return $this->ExceptionBoundaryProgramGuid;
    }
    /**
     * Set ExceptionBoundaryProgramGuid value
     * @param string $exceptionBoundaryProgramGuid
     * @return \StructType\ExceptionBoundaryProgram
     */
    public function setExceptionBoundaryProgramGuid($exceptionBoundaryProgramGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($exceptionBoundaryProgramGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $exceptionBoundaryProgramGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($exceptionBoundaryProgramGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($exceptionBoundaryProgramGuid) && !is_string($exceptionBoundaryProgramGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionBoundaryProgramGuid)), __LINE__);
        }
        $this->ExceptionBoundaryProgramGuid = $exceptionBoundaryProgramGuid;
        return $this;
    }
    /**
     * Get Exclude value
     * @return bool|null
     */
    public function getExclude()
    {
        return $this->Exclude;
    }
    /**
     * Set Exclude value
     * @param bool $exclude
     * @return \StructType\ExceptionBoundaryProgram
     */
    public function setExclude($exclude = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude) && !is_bool($exclude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($exclude)), __LINE__);
        }
        $this->Exclude = $exclude;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\ExceptionBoundaryProgram
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\ExceptionBoundaryProgram
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get ProgramGuid value
     * @return string|null
     */
    public function getProgramGuid()
    {
        return $this->ProgramGuid;
    }
    /**
     * Set ProgramGuid value
     * @param string $programGuid
     * @return \StructType\ExceptionBoundaryProgram
     */
    public function setProgramGuid($programGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($programGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $programGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($programGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($programGuid) && !is_string($programGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($programGuid)), __LINE__);
        }
        $this->ProgramGuid = $programGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExceptionBoundaryProgram
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
