<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeadheadWaypoint StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DeadheadWaypoint
 * @subpackage Structs
 */
class DeadheadWaypoint extends AbstractStructBase
{
    /**
     * The DeadheadGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeadheadGuid;
    /**
     * The DeadheadWaypointGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeadheadWaypointGuid;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The LatLong
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Position
     */
    public $LatLong;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Position;
    /**
     * The PositionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PositionType
     */
    public $PositionType;
    /**
     * The PositionTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PositionTypeGuid;
    /**
     * The SortOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SortOrder;
    /**
     * Constructor method for DeadheadWaypoint
     * @uses DeadheadWaypoint::setDeadheadGuid()
     * @uses DeadheadWaypoint::setDeadheadWaypointGuid()
     * @uses DeadheadWaypoint::setID()
     * @uses DeadheadWaypoint::setLatLong()
     * @uses DeadheadWaypoint::setPosition()
     * @uses DeadheadWaypoint::setPositionType()
     * @uses DeadheadWaypoint::setPositionTypeGuid()
     * @uses DeadheadWaypoint::setSortOrder()
     * @param string $deadheadGuid
     * @param string $deadheadWaypointGuid
     * @param \StructType\BPID $iD
     * @param \StructType\Position $latLong
     * @param string $position
     * @param \StructType\PositionType $positionType
     * @param string $positionTypeGuid
     * @param int $sortOrder
     */
    public function __construct($deadheadGuid = null, $deadheadWaypointGuid = null, \StructType\BPID $iD = null, \StructType\Position $latLong = null, $position = null, \StructType\PositionType $positionType = null, $positionTypeGuid = null, $sortOrder = null)
    {
        $this
            ->setDeadheadGuid($deadheadGuid)
            ->setDeadheadWaypointGuid($deadheadWaypointGuid)
            ->setID($iD)
            ->setLatLong($latLong)
            ->setPosition($position)
            ->setPositionType($positionType)
            ->setPositionTypeGuid($positionTypeGuid)
            ->setSortOrder($sortOrder);
    }
    /**
     * Get DeadheadGuid value
     * @return string|null
     */
    public function getDeadheadGuid()
    {
        return $this->DeadheadGuid;
    }
    /**
     * Set DeadheadGuid value
     * @param string $deadheadGuid
     * @return \StructType\DeadheadWaypoint
     */
    public function setDeadheadGuid($deadheadGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($deadheadGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deadheadGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($deadheadGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deadheadGuid) && !is_string($deadheadGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deadheadGuid)), __LINE__);
        }
        $this->DeadheadGuid = $deadheadGuid;
        return $this;
    }
    /**
     * Get DeadheadWaypointGuid value
     * @return string|null
     */
    public function getDeadheadWaypointGuid()
    {
        return $this->DeadheadWaypointGuid;
    }
    /**
     * Set DeadheadWaypointGuid value
     * @param string $deadheadWaypointGuid
     * @return \StructType\DeadheadWaypoint
     */
    public function setDeadheadWaypointGuid($deadheadWaypointGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($deadheadWaypointGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deadheadWaypointGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($deadheadWaypointGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deadheadWaypointGuid) && !is_string($deadheadWaypointGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deadheadWaypointGuid)), __LINE__);
        }
        $this->DeadheadWaypointGuid = $deadheadWaypointGuid;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\DeadheadWaypoint
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get LatLong value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Position|null
     */
    public function getLatLong()
    {
        return isset($this->LatLong) ? $this->LatLong : null;
    }
    /**
     * Set LatLong value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Position $latLong
     * @return \StructType\DeadheadWaypoint
     */
    public function setLatLong(\StructType\Position $latLong = null)
    {
        if (is_null($latLong) || (is_array($latLong) && empty($latLong))) {
            unset($this->LatLong);
        } else {
            $this->LatLong = $latLong;
        }
        return $this;
    }
    /**
     * Get Position value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPosition()
    {
        return isset($this->Position) ? $this->Position : null;
    }
    /**
     * Set Position value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $position
     * @return \StructType\DeadheadWaypoint
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($position)), __LINE__);
        }
        if (is_null($position) || (is_array($position) && empty($position))) {
            unset($this->Position);
        } else {
            $this->Position = $position;
        }
        return $this;
    }
    /**
     * Get PositionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PositionType|null
     */
    public function getPositionType()
    {
        return isset($this->PositionType) ? $this->PositionType : null;
    }
    /**
     * Set PositionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PositionType $positionType
     * @return \StructType\DeadheadWaypoint
     */
    public function setPositionType(\StructType\PositionType $positionType = null)
    {
        if (is_null($positionType) || (is_array($positionType) && empty($positionType))) {
            unset($this->PositionType);
        } else {
            $this->PositionType = $positionType;
        }
        return $this;
    }
    /**
     * Get PositionTypeGuid value
     * @return string|null
     */
    public function getPositionTypeGuid()
    {
        return $this->PositionTypeGuid;
    }
    /**
     * Set PositionTypeGuid value
     * @param string $positionTypeGuid
     * @return \StructType\DeadheadWaypoint
     */
    public function setPositionTypeGuid($positionTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($positionTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $positionTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($positionTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($positionTypeGuid) && !is_string($positionTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($positionTypeGuid)), __LINE__);
        }
        $this->PositionTypeGuid = $positionTypeGuid;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param int $sortOrder
     * @return \StructType\DeadheadWaypoint
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !is_numeric($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeadheadWaypoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
