<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Deadhead StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Deadhead
 * @subpackage Structs
 */
class Deadhead extends AbstractStructBase
{
    /**
     * The DeadheadGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeadheadGuid;
    /**
     * The DeadheadTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeadheadTypeGuid;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Distance;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ElapsedTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ElapsedTime;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The LatLongs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPosition
     */
    public $LatLongs;
    /**
     * The RetireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RetireDate;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeadheadType
     */
    public $Type;
    /**
     * Constructor method for Deadhead
     * @uses Deadhead::setDeadheadGuid()
     * @uses Deadhead::setDeadheadTypeGuid()
     * @uses Deadhead::setDistance()
     * @uses Deadhead::setEffectiveDate()
     * @uses Deadhead::setElapsedTime()
     * @uses Deadhead::setID()
     * @uses Deadhead::setLatLongs()
     * @uses Deadhead::setRetireDate()
     * @uses Deadhead::setType()
     * @param string $deadheadGuid
     * @param string $deadheadTypeGuid
     * @param float $distance
     * @param string $effectiveDate
     * @param float $elapsedTime
     * @param \StructType\BPID $iD
     * @param \ArrayType\ArrayOfPosition $latLongs
     * @param string $retireDate
     * @param \StructType\DeadheadType $type
     */
    public function __construct($deadheadGuid = null, $deadheadTypeGuid = null, $distance = null, $effectiveDate = null, $elapsedTime = null, \StructType\BPID $iD = null, \ArrayType\ArrayOfPosition $latLongs = null, $retireDate = null, \StructType\DeadheadType $type = null)
    {
        $this
            ->setDeadheadGuid($deadheadGuid)
            ->setDeadheadTypeGuid($deadheadTypeGuid)
            ->setDistance($distance)
            ->setEffectiveDate($effectiveDate)
            ->setElapsedTime($elapsedTime)
            ->setID($iD)
            ->setLatLongs($latLongs)
            ->setRetireDate($retireDate)
            ->setType($type);
    }
    /**
     * Get DeadheadGuid value
     * @return string|null
     */
    public function getDeadheadGuid()
    {
        return $this->DeadheadGuid;
    }
    /**
     * Set DeadheadGuid value
     * @param string $deadheadGuid
     * @return \StructType\Deadhead
     */
    public function setDeadheadGuid($deadheadGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($deadheadGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deadheadGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($deadheadGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deadheadGuid) && !is_string($deadheadGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deadheadGuid)), __LINE__);
        }
        $this->DeadheadGuid = $deadheadGuid;
        return $this;
    }
    /**
     * Get DeadheadTypeGuid value
     * @return string|null
     */
    public function getDeadheadTypeGuid()
    {
        return $this->DeadheadTypeGuid;
    }
    /**
     * Set DeadheadTypeGuid value
     * @param string $deadheadTypeGuid
     * @return \StructType\Deadhead
     */
    public function setDeadheadTypeGuid($deadheadTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($deadheadTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deadheadTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($deadheadTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deadheadTypeGuid) && !is_string($deadheadTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deadheadTypeGuid)), __LINE__);
        }
        $this->DeadheadTypeGuid = $deadheadTypeGuid;
        return $this;
    }
    /**
     * Get Distance value
     * @return float|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param float $distance
     * @return \StructType\Deadhead
     */
    public function setDistance($distance = null)
    {
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Deadhead
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ElapsedTime value
     * @return float|null
     */
    public function getElapsedTime()
    {
        return $this->ElapsedTime;
    }
    /**
     * Set ElapsedTime value
     * @param float $elapsedTime
     * @return \StructType\Deadhead
     */
    public function setElapsedTime($elapsedTime = null)
    {
        $this->ElapsedTime = $elapsedTime;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\Deadhead
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get LatLongs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPosition|null
     */
    public function getLatLongs()
    {
        return isset($this->LatLongs) ? $this->LatLongs : null;
    }
    /**
     * Set LatLongs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPosition $latLongs
     * @return \StructType\Deadhead
     */
    public function setLatLongs(\ArrayType\ArrayOfPosition $latLongs = null)
    {
        if (is_null($latLongs) || (is_array($latLongs) && empty($latLongs))) {
            unset($this->LatLongs);
        } else {
            $this->LatLongs = $latLongs;
        }
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\Deadhead
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeadheadType|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DeadheadType $type
     * @return \StructType\Deadhead
     */
    public function setType(\StructType\DeadheadType $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Deadhead
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
