<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Corner StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Corner
 * @subpackage Structs
 */
class Corner extends AbstractStructBase
{
    /**
     * The CornerGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CornerGuid;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The LatLong
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Position
     */
    public $LatLong;
    /**
     * The Road1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Road1;
    /**
     * The Road2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Road2;
    /**
     * Constructor method for Corner
     * @uses Corner::setCornerGuid()
     * @uses Corner::setID()
     * @uses Corner::setLatLong()
     * @uses Corner::setRoad1()
     * @uses Corner::setRoad2()
     * @param string $cornerGuid
     * @param \StructType\BPID $iD
     * @param \StructType\Position $latLong
     * @param string $road1
     * @param string $road2
     */
    public function __construct($cornerGuid = null, \StructType\BPID $iD = null, \StructType\Position $latLong = null, $road1 = null, $road2 = null)
    {
        $this
            ->setCornerGuid($cornerGuid)
            ->setID($iD)
            ->setLatLong($latLong)
            ->setRoad1($road1)
            ->setRoad2($road2);
    }
    /**
     * Get CornerGuid value
     * @return string|null
     */
    public function getCornerGuid()
    {
        return $this->CornerGuid;
    }
    /**
     * Set CornerGuid value
     * @param string $cornerGuid
     * @return \StructType\Corner
     */
    public function setCornerGuid($cornerGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($cornerGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cornerGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($cornerGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cornerGuid) && !is_string($cornerGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cornerGuid)), __LINE__);
        }
        $this->CornerGuid = $cornerGuid;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\Corner
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get LatLong value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Position|null
     */
    public function getLatLong()
    {
        return isset($this->LatLong) ? $this->LatLong : null;
    }
    /**
     * Set LatLong value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Position $latLong
     * @return \StructType\Corner
     */
    public function setLatLong(\StructType\Position $latLong = null)
    {
        if (is_null($latLong) || (is_array($latLong) && empty($latLong))) {
            unset($this->LatLong);
        } else {
            $this->LatLong = $latLong;
        }
        return $this;
    }
    /**
     * Get Road1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoad1()
    {
        return isset($this->Road1) ? $this->Road1 : null;
    }
    /**
     * Set Road1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $road1
     * @return \StructType\Corner
     */
    public function setRoad1($road1 = null)
    {
        // validation for constraint: string
        if (!is_null($road1) && !is_string($road1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($road1)), __LINE__);
        }
        if (is_null($road1) || (is_array($road1) && empty($road1))) {
            unset($this->Road1);
        } else {
            $this->Road1 = $road1;
        }
        return $this;
    }
    /**
     * Get Road2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoad2()
    {
        return isset($this->Road2) ? $this->Road2 : null;
    }
    /**
     * Set Road2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $road2
     * @return \StructType\Corner
     */
    public function setRoad2($road2 = null)
    {
        // validation for constraint: string
        if (!is_null($road2) && !is_string($road2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($road2)), __LINE__);
        }
        if (is_null($road2) || (is_array($road2) && empty($road2))) {
            unset($this->Road2);
        } else {
            $this->Road2 = $road2;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Corner
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
