<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusStopDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BusStopDetails
 * @subpackage Structs
 */
class BusStopDetails extends AbstractStructBase
{
    /**
     * The BusStopInformation
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\BusStopBasic
     */
    public $BusStopInformation;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The LatLong
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Position
     */
    public $LatLong;
    /**
     * The ModifiedDate
     * @var string
     */
    public $ModifiedDate;
    /**
     * The OperatorName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OperatorName;
    /**
     * The RouteID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RouteID;
    /**
     * Constructor method for BusStopDetails
     * @uses BusStopDetails::setBusStopInformation()
     * @uses BusStopDetails::setCreatedDate()
     * @uses BusStopDetails::setLatLong()
     * @uses BusStopDetails::setModifiedDate()
     * @uses BusStopDetails::setOperatorName()
     * @uses BusStopDetails::setRouteID()
     * @param \StructType\BusStopBasic $busStopInformation
     * @param string $createdDate
     * @param \StructType\Position $latLong
     * @param string $modifiedDate
     * @param string $operatorName
     * @param string $routeID
     */
    public function __construct(\StructType\BusStopBasic $busStopInformation = null, $createdDate = null, \StructType\Position $latLong = null, $modifiedDate = null, $operatorName = null, $routeID = null)
    {
        $this
            ->setBusStopInformation($busStopInformation)
            ->setCreatedDate($createdDate)
            ->setLatLong($latLong)
            ->setModifiedDate($modifiedDate)
            ->setOperatorName($operatorName)
            ->setRouteID($routeID);
    }
    /**
     * Get BusStopInformation value
     * @return \StructType\BusStopBasic|null
     */
    public function getBusStopInformation()
    {
        return $this->BusStopInformation;
    }
    /**
     * Set BusStopInformation value
     * @param \StructType\BusStopBasic $busStopInformation
     * @return \StructType\BusStopDetails
     */
    public function setBusStopInformation(\StructType\BusStopBasic $busStopInformation = null)
    {
        $this->BusStopInformation = $busStopInformation;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\BusStopDetails
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get LatLong value
     * @return \StructType\Position|null
     */
    public function getLatLong()
    {
        return $this->LatLong;
    }
    /**
     * Set LatLong value
     * @param \StructType\Position $latLong
     * @return \StructType\BusStopDetails
     */
    public function setLatLong(\StructType\Position $latLong = null)
    {
        $this->LatLong = $latLong;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * @return string|null
     */
    public function getModifiedDate()
    {
        return $this->ModifiedDate;
    }
    /**
     * Set ModifiedDate value
     * @param string $modifiedDate
     * @return \StructType\BusStopDetails
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedDate)), __LINE__);
        }
        $this->ModifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get OperatorName value
     * @return string|null
     */
    public function getOperatorName()
    {
        return $this->OperatorName;
    }
    /**
     * Set OperatorName value
     * @param string $operatorName
     * @return \StructType\BusStopDetails
     */
    public function setOperatorName($operatorName = null)
    {
        // validation for constraint: string
        if (!is_null($operatorName) && !is_string($operatorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatorName)), __LINE__);
        }
        $this->OperatorName = $operatorName;
        return $this;
    }
    /**
     * Get RouteID value
     * @return string|null
     */
    public function getRouteID()
    {
        return $this->RouteID;
    }
    /**
     * Set RouteID value
     * @param string $routeID
     * @return \StructType\BusStopDetails
     */
    public function setRouteID($routeID = null)
    {
        // validation for constraint: string
        if (!is_null($routeID) && !is_string($routeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeID)), __LINE__);
        }
        $this->RouteID = $routeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusStopDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
