<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusStopBasic StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BusStopBasic
 * @subpackage Structs
 */
class BusStopBasic extends AbstractStructBase
{
    /**
     * The Active
     * @var bool
     */
    public $Active;
    /**
     * The BusStopID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BusStopID;
    /**
     * The BusStopType
     * @var string
     */
    public $BusStopType;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Position;
    /**
     * The RHSPickup
     * @var bool
     */
    public $RHSPickup;
    /**
     * The RetireDate
     * @var string
     */
    public $RetireDate;
    /**
     * The RunID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RunID;
    /**
     * The SpecialEd
     * @var bool
     */
    public $SpecialEd;
    /**
     * The Time
     * @var string
     */
    public $Time;
    /**
     * The Frequency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Frequency
     */
    public $Frequency;
    /**
     * Constructor method for BusStopBasic
     * @uses BusStopBasic::setActive()
     * @uses BusStopBasic::setBusStopID()
     * @uses BusStopBasic::setBusStopType()
     * @uses BusStopBasic::setDescription()
     * @uses BusStopBasic::setEffectiveDate()
     * @uses BusStopBasic::setOrder()
     * @uses BusStopBasic::setPosition()
     * @uses BusStopBasic::setRHSPickup()
     * @uses BusStopBasic::setRetireDate()
     * @uses BusStopBasic::setRunID()
     * @uses BusStopBasic::setSpecialEd()
     * @uses BusStopBasic::setTime()
     * @uses BusStopBasic::setFrequency()
     * @param bool $active
     * @param string $busStopID
     * @param string $busStopType
     * @param string $description
     * @param string $effectiveDate
     * @param int $order
     * @param string $position
     * @param bool $rHSPickup
     * @param string $retireDate
     * @param string $runID
     * @param bool $specialEd
     * @param string $time
     * @param \StructType\Frequency $frequency
     */
    public function __construct($active = null, $busStopID = null, $busStopType = null, $description = null, $effectiveDate = null, $order = null, $position = null, $rHSPickup = null, $retireDate = null, $runID = null, $specialEd = null, $time = null, \StructType\Frequency $frequency = null)
    {
        $this
            ->setActive($active)
            ->setBusStopID($busStopID)
            ->setBusStopType($busStopType)
            ->setDescription($description)
            ->setEffectiveDate($effectiveDate)
            ->setOrder($order)
            ->setPosition($position)
            ->setRHSPickup($rHSPickup)
            ->setRetireDate($retireDate)
            ->setRunID($runID)
            ->setSpecialEd($specialEd)
            ->setTime($time)
            ->setFrequency($frequency);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\BusStopBasic
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get BusStopID value
     * @return string|null
     */
    public function getBusStopID()
    {
        return $this->BusStopID;
    }
    /**
     * Set BusStopID value
     * @param string $busStopID
     * @return \StructType\BusStopBasic
     */
    public function setBusStopID($busStopID = null)
    {
        // validation for constraint: string
        if (!is_null($busStopID) && !is_string($busStopID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($busStopID)), __LINE__);
        }
        $this->BusStopID = $busStopID;
        return $this;
    }
    /**
     * Get BusStopType value
     * @return string|null
     */
    public function getBusStopType()
    {
        return $this->BusStopType;
    }
    /**
     * Set BusStopType value
     * @uses \EnumType\BusStopType::valueIsValid()
     * @uses \EnumType\BusStopType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busStopType
     * @return \StructType\BusStopBasic
     */
    public function setBusStopType($busStopType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusStopType::valueIsValid($busStopType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $busStopType, implode(', ', \EnumType\BusStopType::getValidValues())), __LINE__);
        }
        $this->BusStopType = $busStopType;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\BusStopBasic
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\BusStopBasic
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\BusStopBasic
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param string $position
     * @return \StructType\BusStopBasic
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get RHSPickup value
     * @return bool|null
     */
    public function getRHSPickup()
    {
        return $this->RHSPickup;
    }
    /**
     * Set RHSPickup value
     * @param bool $rHSPickup
     * @return \StructType\BusStopBasic
     */
    public function setRHSPickup($rHSPickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($rHSPickup) && !is_bool($rHSPickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($rHSPickup)), __LINE__);
        }
        $this->RHSPickup = $rHSPickup;
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\BusStopBasic
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get RunID value
     * @return string|null
     */
    public function getRunID()
    {
        return $this->RunID;
    }
    /**
     * Set RunID value
     * @param string $runID
     * @return \StructType\BusStopBasic
     */
    public function setRunID($runID = null)
    {
        // validation for constraint: string
        if (!is_null($runID) && !is_string($runID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runID)), __LINE__);
        }
        $this->RunID = $runID;
        return $this;
    }
    /**
     * Get SpecialEd value
     * @return bool|null
     */
    public function getSpecialEd()
    {
        return $this->SpecialEd;
    }
    /**
     * Set SpecialEd value
     * @param bool $specialEd
     * @return \StructType\BusStopBasic
     */
    public function setSpecialEd($specialEd = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialEd) && !is_bool($specialEd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($specialEd)), __LINE__);
        }
        $this->SpecialEd = $specialEd;
        return $this;
    }
    /**
     * Get Time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \StructType\BusStopBasic
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get Frequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Frequency|null
     */
    public function getFrequency()
    {
        return isset($this->Frequency) ? $this->Frequency : null;
    }
    /**
     * Set Frequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Frequency $frequency
     * @return \StructType\BusStopBasic
     */
    public function setFrequency(\StructType\Frequency $frequency = null)
    {
        if (is_null($frequency) || (is_array($frequency) && empty($frequency))) {
            unset($this->Frequency);
        } else {
            $this->Frequency = $frequency;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusStopBasic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
