<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address_v2 StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Address_v2
 * @subpackage Structs
 */
class Address_v2 extends AbstractStructBase
{
    /**
     * The AddressGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddressGuid;
    /**
     * The AddressTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddressTypeGuid;
    /**
     * The Apt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Apt;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The ImportApt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportApt;
    /**
     * The ImportMunicipality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportMunicipality;
    /**
     * The ImportPostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportPostalCode;
    /**
     * The ImportProvince
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportProvince;
    /**
     * The ImportStreetName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportStreetName;
    /**
     * The ImportStreetNum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportStreetNum;
    /**
     * The LatLong
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Position
     */
    public $LatLong;
    /**
     * The LocationID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocationID;
    /**
     * The MailingAddress1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MailingAddress1;
    /**
     * The MailingAddress2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MailingAddress2;
    /**
     * The Municipality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Municipality;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostalCode;
    /**
     * The Provice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Provice;
    /**
     * The RetireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RetireDate;
    /**
     * The SIFGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SIFGuid;
    /**
     * The StreetName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetName;
    /**
     * The StreetNum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $StreetNum;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AddressType
     */
    public $Type;
    /**
     * Constructor method for Address_v2
     * @uses Address_v2::setAddressGuid()
     * @uses Address_v2::setAddressTypeGuid()
     * @uses Address_v2::setApt()
     * @uses Address_v2::setEffectiveDate()
     * @uses Address_v2::setID()
     * @uses Address_v2::setImportApt()
     * @uses Address_v2::setImportMunicipality()
     * @uses Address_v2::setImportPostalCode()
     * @uses Address_v2::setImportProvince()
     * @uses Address_v2::setImportStreetName()
     * @uses Address_v2::setImportStreetNum()
     * @uses Address_v2::setLatLong()
     * @uses Address_v2::setLocationID()
     * @uses Address_v2::setMailingAddress1()
     * @uses Address_v2::setMailingAddress2()
     * @uses Address_v2::setMunicipality()
     * @uses Address_v2::setPostalCode()
     * @uses Address_v2::setProvice()
     * @uses Address_v2::setRetireDate()
     * @uses Address_v2::setSIFGuid()
     * @uses Address_v2::setStreetName()
     * @uses Address_v2::setStreetNum()
     * @uses Address_v2::setType()
     * @param string $addressGuid
     * @param string $addressTypeGuid
     * @param string $apt
     * @param string $effectiveDate
     * @param \StructType\BPID $iD
     * @param string $importApt
     * @param string $importMunicipality
     * @param string $importPostalCode
     * @param string $importProvince
     * @param string $importStreetName
     * @param string $importStreetNum
     * @param \StructType\Position $latLong
     * @param string $locationID
     * @param string $mailingAddress1
     * @param string $mailingAddress2
     * @param string $municipality
     * @param string $postalCode
     * @param string $provice
     * @param string $retireDate
     * @param string $sIFGuid
     * @param string $streetName
     * @param int $streetNum
     * @param \StructType\AddressType $type
     */
    public function __construct($addressGuid = null, $addressTypeGuid = null, $apt = null, $effectiveDate = null, \StructType\BPID $iD = null, $importApt = null, $importMunicipality = null, $importPostalCode = null, $importProvince = null, $importStreetName = null, $importStreetNum = null, \StructType\Position $latLong = null, $locationID = null, $mailingAddress1 = null, $mailingAddress2 = null, $municipality = null, $postalCode = null, $provice = null, $retireDate = null, $sIFGuid = null, $streetName = null, $streetNum = null, \StructType\AddressType $type = null)
    {
        $this
            ->setAddressGuid($addressGuid)
            ->setAddressTypeGuid($addressTypeGuid)
            ->setApt($apt)
            ->setEffectiveDate($effectiveDate)
            ->setID($iD)
            ->setImportApt($importApt)
            ->setImportMunicipality($importMunicipality)
            ->setImportPostalCode($importPostalCode)
            ->setImportProvince($importProvince)
            ->setImportStreetName($importStreetName)
            ->setImportStreetNum($importStreetNum)
            ->setLatLong($latLong)
            ->setLocationID($locationID)
            ->setMailingAddress1($mailingAddress1)
            ->setMailingAddress2($mailingAddress2)
            ->setMunicipality($municipality)
            ->setPostalCode($postalCode)
            ->setProvice($provice)
            ->setRetireDate($retireDate)
            ->setSIFGuid($sIFGuid)
            ->setStreetName($streetName)
            ->setStreetNum($streetNum)
            ->setType($type);
    }
    /**
     * Get AddressGuid value
     * @return string|null
     */
    public function getAddressGuid()
    {
        return $this->AddressGuid;
    }
    /**
     * Set AddressGuid value
     * @param string $addressGuid
     * @return \StructType\Address_v2
     */
    public function setAddressGuid($addressGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addressGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addressGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($addressGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressGuid) && !is_string($addressGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressGuid)), __LINE__);
        }
        $this->AddressGuid = $addressGuid;
        return $this;
    }
    /**
     * Get AddressTypeGuid value
     * @return string|null
     */
    public function getAddressTypeGuid()
    {
        return $this->AddressTypeGuid;
    }
    /**
     * Set AddressTypeGuid value
     * @param string $addressTypeGuid
     * @return \StructType\Address_v2
     */
    public function setAddressTypeGuid($addressTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addressTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addressTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($addressTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressTypeGuid) && !is_string($addressTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressTypeGuid)), __LINE__);
        }
        $this->AddressTypeGuid = $addressTypeGuid;
        return $this;
    }
    /**
     * Get Apt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApt()
    {
        return isset($this->Apt) ? $this->Apt : null;
    }
    /**
     * Set Apt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apt
     * @return \StructType\Address_v2
     */
    public function setApt($apt = null)
    {
        // validation for constraint: string
        if (!is_null($apt) && !is_string($apt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apt)), __LINE__);
        }
        if (is_null($apt) || (is_array($apt) && empty($apt))) {
            unset($this->Apt);
        } else {
            $this->Apt = $apt;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Address_v2
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\Address_v2
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get ImportApt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportApt()
    {
        return isset($this->ImportApt) ? $this->ImportApt : null;
    }
    /**
     * Set ImportApt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importApt
     * @return \StructType\Address_v2
     */
    public function setImportApt($importApt = null)
    {
        // validation for constraint: string
        if (!is_null($importApt) && !is_string($importApt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importApt)), __LINE__);
        }
        if (is_null($importApt) || (is_array($importApt) && empty($importApt))) {
            unset($this->ImportApt);
        } else {
            $this->ImportApt = $importApt;
        }
        return $this;
    }
    /**
     * Get ImportMunicipality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportMunicipality()
    {
        return isset($this->ImportMunicipality) ? $this->ImportMunicipality : null;
    }
    /**
     * Set ImportMunicipality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importMunicipality
     * @return \StructType\Address_v2
     */
    public function setImportMunicipality($importMunicipality = null)
    {
        // validation for constraint: string
        if (!is_null($importMunicipality) && !is_string($importMunicipality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importMunicipality)), __LINE__);
        }
        if (is_null($importMunicipality) || (is_array($importMunicipality) && empty($importMunicipality))) {
            unset($this->ImportMunicipality);
        } else {
            $this->ImportMunicipality = $importMunicipality;
        }
        return $this;
    }
    /**
     * Get ImportPostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportPostalCode()
    {
        return isset($this->ImportPostalCode) ? $this->ImportPostalCode : null;
    }
    /**
     * Set ImportPostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importPostalCode
     * @return \StructType\Address_v2
     */
    public function setImportPostalCode($importPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($importPostalCode) && !is_string($importPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importPostalCode)), __LINE__);
        }
        if (is_null($importPostalCode) || (is_array($importPostalCode) && empty($importPostalCode))) {
            unset($this->ImportPostalCode);
        } else {
            $this->ImportPostalCode = $importPostalCode;
        }
        return $this;
    }
    /**
     * Get ImportProvince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportProvince()
    {
        return isset($this->ImportProvince) ? $this->ImportProvince : null;
    }
    /**
     * Set ImportProvince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importProvince
     * @return \StructType\Address_v2
     */
    public function setImportProvince($importProvince = null)
    {
        // validation for constraint: string
        if (!is_null($importProvince) && !is_string($importProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importProvince)), __LINE__);
        }
        if (is_null($importProvince) || (is_array($importProvince) && empty($importProvince))) {
            unset($this->ImportProvince);
        } else {
            $this->ImportProvince = $importProvince;
        }
        return $this;
    }
    /**
     * Get ImportStreetName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportStreetName()
    {
        return isset($this->ImportStreetName) ? $this->ImportStreetName : null;
    }
    /**
     * Set ImportStreetName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importStreetName
     * @return \StructType\Address_v2
     */
    public function setImportStreetName($importStreetName = null)
    {
        // validation for constraint: string
        if (!is_null($importStreetName) && !is_string($importStreetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importStreetName)), __LINE__);
        }
        if (is_null($importStreetName) || (is_array($importStreetName) && empty($importStreetName))) {
            unset($this->ImportStreetName);
        } else {
            $this->ImportStreetName = $importStreetName;
        }
        return $this;
    }
    /**
     * Get ImportStreetNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportStreetNum()
    {
        return isset($this->ImportStreetNum) ? $this->ImportStreetNum : null;
    }
    /**
     * Set ImportStreetNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importStreetNum
     * @return \StructType\Address_v2
     */
    public function setImportStreetNum($importStreetNum = null)
    {
        // validation for constraint: string
        if (!is_null($importStreetNum) && !is_string($importStreetNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importStreetNum)), __LINE__);
        }
        if (is_null($importStreetNum) || (is_array($importStreetNum) && empty($importStreetNum))) {
            unset($this->ImportStreetNum);
        } else {
            $this->ImportStreetNum = $importStreetNum;
        }
        return $this;
    }
    /**
     * Get LatLong value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Position|null
     */
    public function getLatLong()
    {
        return isset($this->LatLong) ? $this->LatLong : null;
    }
    /**
     * Set LatLong value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Position $latLong
     * @return \StructType\Address_v2
     */
    public function setLatLong(\StructType\Position $latLong = null)
    {
        if (is_null($latLong) || (is_array($latLong) && empty($latLong))) {
            unset($this->LatLong);
        } else {
            $this->LatLong = $latLong;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationID
     * @return \StructType\Address_v2
     */
    public function setLocationID($locationID = null)
    {
        // validation for constraint: string
        if (!is_null($locationID) && !is_string($locationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationID)), __LINE__);
        }
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get MailingAddress1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailingAddress1()
    {
        return isset($this->MailingAddress1) ? $this->MailingAddress1 : null;
    }
    /**
     * Set MailingAddress1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailingAddress1
     * @return \StructType\Address_v2
     */
    public function setMailingAddress1($mailingAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($mailingAddress1) && !is_string($mailingAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingAddress1)), __LINE__);
        }
        if (is_null($mailingAddress1) || (is_array($mailingAddress1) && empty($mailingAddress1))) {
            unset($this->MailingAddress1);
        } else {
            $this->MailingAddress1 = $mailingAddress1;
        }
        return $this;
    }
    /**
     * Get MailingAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailingAddress2()
    {
        return isset($this->MailingAddress2) ? $this->MailingAddress2 : null;
    }
    /**
     * Set MailingAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailingAddress2
     * @return \StructType\Address_v2
     */
    public function setMailingAddress2($mailingAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($mailingAddress2) && !is_string($mailingAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingAddress2)), __LINE__);
        }
        if (is_null($mailingAddress2) || (is_array($mailingAddress2) && empty($mailingAddress2))) {
            unset($this->MailingAddress2);
        } else {
            $this->MailingAddress2 = $mailingAddress2;
        }
        return $this;
    }
    /**
     * Get Municipality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMunicipality()
    {
        return isset($this->Municipality) ? $this->Municipality : null;
    }
    /**
     * Set Municipality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $municipality
     * @return \StructType\Address_v2
     */
    public function setMunicipality($municipality = null)
    {
        // validation for constraint: string
        if (!is_null($municipality) && !is_string($municipality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($municipality)), __LINE__);
        }
        if (is_null($municipality) || (is_array($municipality) && empty($municipality))) {
            unset($this->Municipality);
        } else {
            $this->Municipality = $municipality;
        }
        return $this;
    }
    /**
     * Get PostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostalCode()
    {
        return isset($this->PostalCode) ? $this->PostalCode : null;
    }
    /**
     * Set PostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postalCode
     * @return \StructType\Address_v2
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        if (is_null($postalCode) || (is_array($postalCode) && empty($postalCode))) {
            unset($this->PostalCode);
        } else {
            $this->PostalCode = $postalCode;
        }
        return $this;
    }
    /**
     * Get Provice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvice()
    {
        return isset($this->Provice) ? $this->Provice : null;
    }
    /**
     * Set Provice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provice
     * @return \StructType\Address_v2
     */
    public function setProvice($provice = null)
    {
        // validation for constraint: string
        if (!is_null($provice) && !is_string($provice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provice)), __LINE__);
        }
        if (is_null($provice) || (is_array($provice) && empty($provice))) {
            unset($this->Provice);
        } else {
            $this->Provice = $provice;
        }
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\Address_v2
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get SIFGuid value
     * @return string|null
     */
    public function getSIFGuid()
    {
        return $this->SIFGuid;
    }
    /**
     * Set SIFGuid value
     * @param string $sIFGuid
     * @return \StructType\Address_v2
     */
    public function setSIFGuid($sIFGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sIFGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sIFGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($sIFGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sIFGuid) && !is_string($sIFGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sIFGuid)), __LINE__);
        }
        $this->SIFGuid = $sIFGuid;
        return $this;
    }
    /**
     * Get StreetName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetName()
    {
        return isset($this->StreetName) ? $this->StreetName : null;
    }
    /**
     * Set StreetName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetName
     * @return \StructType\Address_v2
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetName)), __LINE__);
        }
        if (is_null($streetName) || (is_array($streetName) && empty($streetName))) {
            unset($this->StreetName);
        } else {
            $this->StreetName = $streetName;
        }
        return $this;
    }
    /**
     * Get StreetNum value
     * @return int|null
     */
    public function getStreetNum()
    {
        return $this->StreetNum;
    }
    /**
     * Set StreetNum value
     * @param int $streetNum
     * @return \StructType\Address_v2
     */
    public function setStreetNum($streetNum = null)
    {
        // validation for constraint: int
        if (!is_null($streetNum) && !is_numeric($streetNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($streetNum)), __LINE__);
        }
        $this->StreetNum = $streetNum;
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AddressType|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AddressType $type
     * @return \StructType\Address_v2
     */
    public function setType(\StructType\AddressType $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Address_v2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
