<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddressType
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The AddressTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddressTypeGuid;
    /**
     * The AssignOrderDropoff
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AssignOrderDropoff;
    /**
     * The AssignOrderPickup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AssignOrderPickup;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The FilterType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FilterType;
    /**
     * The IsSystem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSystem;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SortOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SortOrder;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setAddressTypeGuid()
     * @uses AddressType::setAssignOrderDropoff()
     * @uses AddressType::setAssignOrderPickup()
     * @uses AddressType::setDescription()
     * @uses AddressType::setFilterType()
     * @uses AddressType::setIsSystem()
     * @uses AddressType::setName()
     * @uses AddressType::setSortOrder()
     * @param string $addressTypeGuid
     * @param int $assignOrderDropoff
     * @param int $assignOrderPickup
     * @param string $description
     * @param string $filterType
     * @param bool $isSystem
     * @param string $name
     * @param int $sortOrder
     */
    public function __construct($addressTypeGuid = null, $assignOrderDropoff = null, $assignOrderPickup = null, $description = null, $filterType = null, $isSystem = null, $name = null, $sortOrder = null)
    {
        $this
            ->setAddressTypeGuid($addressTypeGuid)
            ->setAssignOrderDropoff($assignOrderDropoff)
            ->setAssignOrderPickup($assignOrderPickup)
            ->setDescription($description)
            ->setFilterType($filterType)
            ->setIsSystem($isSystem)
            ->setName($name)
            ->setSortOrder($sortOrder);
    }
    /**
     * Get AddressTypeGuid value
     * @return string|null
     */
    public function getAddressTypeGuid()
    {
        return $this->AddressTypeGuid;
    }
    /**
     * Set AddressTypeGuid value
     * @param string $addressTypeGuid
     * @return \StructType\AddressType
     */
    public function setAddressTypeGuid($addressTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addressTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addressTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($addressTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressTypeGuid) && !is_string($addressTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressTypeGuid)), __LINE__);
        }
        $this->AddressTypeGuid = $addressTypeGuid;
        return $this;
    }
    /**
     * Get AssignOrderDropoff value
     * @return int|null
     */
    public function getAssignOrderDropoff()
    {
        return $this->AssignOrderDropoff;
    }
    /**
     * Set AssignOrderDropoff value
     * @param int $assignOrderDropoff
     * @return \StructType\AddressType
     */
    public function setAssignOrderDropoff($assignOrderDropoff = null)
    {
        // validation for constraint: int
        if (!is_null($assignOrderDropoff) && !is_numeric($assignOrderDropoff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($assignOrderDropoff)), __LINE__);
        }
        $this->AssignOrderDropoff = $assignOrderDropoff;
        return $this;
    }
    /**
     * Get AssignOrderPickup value
     * @return int|null
     */
    public function getAssignOrderPickup()
    {
        return $this->AssignOrderPickup;
    }
    /**
     * Set AssignOrderPickup value
     * @param int $assignOrderPickup
     * @return \StructType\AddressType
     */
    public function setAssignOrderPickup($assignOrderPickup = null)
    {
        // validation for constraint: int
        if (!is_null($assignOrderPickup) && !is_numeric($assignOrderPickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($assignOrderPickup)), __LINE__);
        }
        $this->AssignOrderPickup = $assignOrderPickup;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\AddressType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get FilterType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilterType()
    {
        return isset($this->FilterType) ? $this->FilterType : null;
    }
    /**
     * Set FilterType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filterType
     * @return \StructType\AddressType
     */
    public function setFilterType($filterType = null)
    {
        // validation for constraint: string
        if (!is_null($filterType) && !is_string($filterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filterType)), __LINE__);
        }
        if (is_null($filterType) || (is_array($filterType) && empty($filterType))) {
            unset($this->FilterType);
        } else {
            $this->FilterType = $filterType;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * @return bool|null
     */
    public function getIsSystem()
    {
        return $this->IsSystem;
    }
    /**
     * Set IsSystem value
     * @param bool $isSystem
     * @return \StructType\AddressType
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSystem)), __LINE__);
        }
        $this->IsSystem = $isSystem;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\AddressType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param int $sortOrder
     * @return \StructType\AddressType
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !is_numeric($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
