<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressEligibility StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddressEligibility
 * @subpackage Structs
 */
class AddressEligibility extends AbstractStructBase
{
    /**
     * The AlternateSchoolID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AlternateSchoolID;
    /**
     * The Grades
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Grades;
    /**
     * The Program
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Program;
    /**
     * The SchoolID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SchoolID;
    /**
     * The SchoolName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SchoolName;
    /**
     * Constructor method for AddressEligibility
     * @uses AddressEligibility::setAlternateSchoolID()
     * @uses AddressEligibility::setGrades()
     * @uses AddressEligibility::setProgram()
     * @uses AddressEligibility::setSchoolID()
     * @uses AddressEligibility::setSchoolName()
     * @param string $alternateSchoolID
     * @param \ArrayType\ArrayOfstring $grades
     * @param string $program
     * @param string $schoolID
     * @param string $schoolName
     */
    public function __construct($alternateSchoolID = null, \ArrayType\ArrayOfstring $grades = null, $program = null, $schoolID = null, $schoolName = null)
    {
        $this
            ->setAlternateSchoolID($alternateSchoolID)
            ->setGrades($grades)
            ->setProgram($program)
            ->setSchoolID($schoolID)
            ->setSchoolName($schoolName);
    }
    /**
     * Get AlternateSchoolID value
     * @return string|null
     */
    public function getAlternateSchoolID()
    {
        return $this->AlternateSchoolID;
    }
    /**
     * Set AlternateSchoolID value
     * @param string $alternateSchoolID
     * @return \StructType\AddressEligibility
     */
    public function setAlternateSchoolID($alternateSchoolID = null)
    {
        // validation for constraint: string
        if (!is_null($alternateSchoolID) && !is_string($alternateSchoolID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alternateSchoolID)), __LINE__);
        }
        $this->AlternateSchoolID = $alternateSchoolID;
        return $this;
    }
    /**
     * Get Grades value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getGrades()
    {
        return $this->Grades;
    }
    /**
     * Set Grades value
     * @param \ArrayType\ArrayOfstring $grades
     * @return \StructType\AddressEligibility
     */
    public function setGrades(\ArrayType\ArrayOfstring $grades = null)
    {
        $this->Grades = $grades;
        return $this;
    }
    /**
     * Get Program value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProgram()
    {
        return isset($this->Program) ? $this->Program : null;
    }
    /**
     * Set Program value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $program
     * @return \StructType\AddressEligibility
     */
    public function setProgram($program = null)
    {
        // validation for constraint: string
        if (!is_null($program) && !is_string($program)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($program)), __LINE__);
        }
        if (is_null($program) || (is_array($program) && empty($program))) {
            unset($this->Program);
        } else {
            $this->Program = $program;
        }
        return $this;
    }
    /**
     * Get SchoolID value
     * @return string|null
     */
    public function getSchoolID()
    {
        return $this->SchoolID;
    }
    /**
     * Set SchoolID value
     * @param string $schoolID
     * @return \StructType\AddressEligibility
     */
    public function setSchoolID($schoolID = null)
    {
        // validation for constraint: string
        if (!is_null($schoolID) && !is_string($schoolID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolID)), __LINE__);
        }
        $this->SchoolID = $schoolID;
        return $this;
    }
    /**
     * Get SchoolName value
     * @return string|null
     */
    public function getSchoolName()
    {
        return $this->SchoolName;
    }
    /**
     * Set SchoolName value
     * @param string $schoolName
     * @return \StructType\AddressEligibility
     */
    public function setSchoolName($schoolName = null)
    {
        // validation for constraint: string
        if (!is_null($schoolName) && !is_string($schoolName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolName)), __LINE__);
        }
        $this->SchoolName = $schoolName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressEligibility
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
