<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessPoint StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AccessPoint
 * @subpackage Structs
 */
class AccessPoint extends AbstractStructBase
{
    /**
     * The AccessPointGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessPointGuid;
    /**
     * The AccessPointID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessPointID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The LatLong
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Position
     */
    public $LatLong;
    /**
     * The Protected
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protected;
    /**
     * The RetireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RetireDate;
    /**
     * The SchoolID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchoolID;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Type;
    /**
     * Constructor method for AccessPoint
     * @uses AccessPoint::setAccessPointGuid()
     * @uses AccessPoint::setAccessPointID()
     * @uses AccessPoint::setActive()
     * @uses AccessPoint::setDescription()
     * @uses AccessPoint::setEffectiveDate()
     * @uses AccessPoint::setID()
     * @uses AccessPoint::setLatLong()
     * @uses AccessPoint::setProtected()
     * @uses AccessPoint::setRetireDate()
     * @uses AccessPoint::setSchoolID()
     * @uses AccessPoint::setType()
     * @param string $accessPointGuid
     * @param string $accessPointID
     * @param bool $active
     * @param string $description
     * @param string $effectiveDate
     * @param \StructType\BPID $iD
     * @param \StructType\Position $latLong
     * @param bool $protected
     * @param string $retireDate
     * @param string $schoolID
     * @param int $type
     */
    public function __construct($accessPointGuid = null, $accessPointID = null, $active = null, $description = null, $effectiveDate = null, \StructType\BPID $iD = null, \StructType\Position $latLong = null, $protected = null, $retireDate = null, $schoolID = null, $type = null)
    {
        $this
            ->setAccessPointGuid($accessPointGuid)
            ->setAccessPointID($accessPointID)
            ->setActive($active)
            ->setDescription($description)
            ->setEffectiveDate($effectiveDate)
            ->setID($iD)
            ->setLatLong($latLong)
            ->setProtected($protected)
            ->setRetireDate($retireDate)
            ->setSchoolID($schoolID)
            ->setType($type);
    }
    /**
     * Get AccessPointGuid value
     * @return string|null
     */
    public function getAccessPointGuid()
    {
        return $this->AccessPointGuid;
    }
    /**
     * Set AccessPointGuid value
     * @param string $accessPointGuid
     * @return \StructType\AccessPoint
     */
    public function setAccessPointGuid($accessPointGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($accessPointGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessPointGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($accessPointGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($accessPointGuid) && !is_string($accessPointGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessPointGuid)), __LINE__);
        }
        $this->AccessPointGuid = $accessPointGuid;
        return $this;
    }
    /**
     * Get AccessPointID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessPointID()
    {
        return isset($this->AccessPointID) ? $this->AccessPointID : null;
    }
    /**
     * Set AccessPointID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessPointID
     * @return \StructType\AccessPoint
     */
    public function setAccessPointID($accessPointID = null)
    {
        // validation for constraint: string
        if (!is_null($accessPointID) && !is_string($accessPointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessPointID)), __LINE__);
        }
        if (is_null($accessPointID) || (is_array($accessPointID) && empty($accessPointID))) {
            unset($this->AccessPointID);
        } else {
            $this->AccessPointID = $accessPointID;
        }
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\AccessPoint
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\AccessPoint
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\AccessPoint
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\AccessPoint
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get LatLong value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Position|null
     */
    public function getLatLong()
    {
        return isset($this->LatLong) ? $this->LatLong : null;
    }
    /**
     * Set LatLong value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Position $latLong
     * @return \StructType\AccessPoint
     */
    public function setLatLong(\StructType\Position $latLong = null)
    {
        if (is_null($latLong) || (is_array($latLong) && empty($latLong))) {
            unset($this->LatLong);
        } else {
            $this->LatLong = $latLong;
        }
        return $this;
    }
    /**
     * Get Protected value
     * @return bool|null
     */
    public function getProtected()
    {
        return $this->Protected;
    }
    /**
     * Set Protected value
     * @param bool $protected
     * @return \StructType\AccessPoint
     */
    public function setProtected($protected = null)
    {
        // validation for constraint: boolean
        if (!is_null($protected) && !is_bool($protected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protected)), __LINE__);
        }
        $this->Protected = $protected;
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\AccessPoint
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get SchoolID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchoolID()
    {
        return isset($this->SchoolID) ? $this->SchoolID : null;
    }
    /**
     * Set SchoolID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schoolID
     * @return \StructType\AccessPoint
     */
    public function setSchoolID($schoolID = null)
    {
        // validation for constraint: string
        if (!is_null($schoolID) && !is_string($schoolID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolID)), __LINE__);
        }
        if (is_null($schoolID) || (is_array($schoolID) && empty($schoolID))) {
            unset($this->SchoolID);
        } else {
            $this->SchoolID = $schoolID;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return int|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\AccessPoint
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !is_numeric($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccessPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
