<?php

namespace EnumType;

/**
 * This class stands for BusStopType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BusStopType
 * @subpackage Enumerations
 */
class BusStopType
{
    /**
     * Constant for value 'PICKUP'
     * @return string 'PICKUP'
     */
    const VALUE_PICKUP = 'PICKUP';
    /**
     * Constant for value 'DROPOFF'
     * @return string 'DROPOFF'
     */
    const VALUE_DROPOFF = 'DROPOFF';
    /**
     * Constant for value 'SCHOOL_PICKUP'
     * @return string 'SCHOOL_PICKUP'
     */
    const VALUE_SCHOOL_PICKUP = 'SCHOOL_PICKUP';
    /**
     * Constant for value 'SCHOOL_DROPOFF'
     * @return string 'SCHOOL_DROPOFF'
     */
    const VALUE_SCHOOL_DROPOFF = 'SCHOOL_DROPOFF';
    /**
     * Constant for value 'TRANSFER_PICKUP'
     * @return string 'TRANSFER_PICKUP'
     */
    const VALUE_TRANSFER_PICKUP = 'TRANSFER_PICKUP';
    /**
     * Constant for value 'TRANSFER_DROPOFF'
     * @return string 'TRANSFER_DROPOFF'
     */
    const VALUE_TRANSFER_DROPOFF = 'TRANSFER_DROPOFF';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PICKUP
     * @uses self::VALUE_DROPOFF
     * @uses self::VALUE_SCHOOL_PICKUP
     * @uses self::VALUE_SCHOOL_DROPOFF
     * @uses self::VALUE_TRANSFER_PICKUP
     * @uses self::VALUE_TRANSFER_DROPOFF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PICKUP,
            self::VALUE_DROPOFF,
            self::VALUE_SCHOOL_PICKUP,
            self::VALUE_SCHOOL_DROPOFF,
            self::VALUE_TRANSFER_PICKUP,
            self::VALUE_TRANSFER_DROPOFF,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
