<?php

namespace EnumType;

/**
 * This class stands for AuthenticationType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AuthenticationType
 * @subpackage Enumerations
 */
class AuthenticationType
{
    /**
     * Constant for value 'StudentID_PIN'
     * @return string 'StudentID_PIN'
     */
    const VALUE_STUDENT_ID_PIN = 'StudentID_PIN';
    /**
     * Constant for value 'StudentID_School_Grade_StreetNo'
     * @return string 'StudentID_School_Grade_StreetNo'
     */
    const VALUE_STUDENT_ID_SCHOOL_GRADE_STREET_NO = 'StudentID_School_Grade_StreetNo';
    /**
     * Constant for value 'LastName_BirthDate_School_Grade'
     * @return string 'LastName_BirthDate_School_Grade'
     */
    const VALUE_LAST_NAME_BIRTH_DATE_SCHOOL_GRADE = 'LastName_BirthDate_School_Grade';
    /**
     * Constant for value 'StudentID_BirthDate_School_Grade'
     * @return string 'StudentID_BirthDate_School_Grade'
     */
    const VALUE_STUDENT_ID_BIRTH_DATE_SCHOOL_GRADE = 'StudentID_BirthDate_School_Grade';
    /**
     * Constant for value 'StudentID_BirthDate_School_StreetNo'
     * @return string 'StudentID_BirthDate_School_StreetNo'
     */
    const VALUE_STUDENT_ID_BIRTH_DATE_SCHOOL_STREET_NO = 'StudentID_BirthDate_School_StreetNo';
    /**
     * Constant for value 'AlternateID_PIN'
     * @return string 'AlternateID_PIN'
     */
    const VALUE_ALTERNATE_ID_PIN = 'AlternateID_PIN';
    /**
     * Constant for value 'AlternateID_School_Grade_StreetNo'
     * @return string 'AlternateID_School_Grade_StreetNo'
     */
    const VALUE_ALTERNATE_ID_SCHOOL_GRADE_STREET_NO = 'AlternateID_School_Grade_StreetNo';
    /**
     * Constant for value 'AlternateID_BirthDate_School_Grade'
     * @return string 'AlternateID_BirthDate_School_Grade'
     */
    const VALUE_ALTERNATE_ID_BIRTH_DATE_SCHOOL_GRADE = 'AlternateID_BirthDate_School_Grade';
    /**
     * Constant for value 'AlternateID_BirthDate_School_StreetNo'
     * @return string 'AlternateID_BirthDate_School_StreetNo'
     */
    const VALUE_ALTERNATE_ID_BIRTH_DATE_SCHOOL_STREET_NO = 'AlternateID_BirthDate_School_StreetNo';
    /**
     * Constant for value 'PIN_RETRIEVAL'
     * @return string 'PIN_RETRIEVAL'
     */
    const VALUE_PIN_RETRIEVAL = 'PIN_RETRIEVAL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STUDENT_ID_PIN
     * @uses self::VALUE_STUDENT_ID_SCHOOL_GRADE_STREET_NO
     * @uses self::VALUE_LAST_NAME_BIRTH_DATE_SCHOOL_GRADE
     * @uses self::VALUE_STUDENT_ID_BIRTH_DATE_SCHOOL_GRADE
     * @uses self::VALUE_STUDENT_ID_BIRTH_DATE_SCHOOL_STREET_NO
     * @uses self::VALUE_ALTERNATE_ID_PIN
     * @uses self::VALUE_ALTERNATE_ID_SCHOOL_GRADE_STREET_NO
     * @uses self::VALUE_ALTERNATE_ID_BIRTH_DATE_SCHOOL_GRADE
     * @uses self::VALUE_ALTERNATE_ID_BIRTH_DATE_SCHOOL_STREET_NO
     * @uses self::VALUE_PIN_RETRIEVAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STUDENT_ID_PIN,
            self::VALUE_STUDENT_ID_SCHOOL_GRADE_STREET_NO,
            self::VALUE_LAST_NAME_BIRTH_DATE_SCHOOL_GRADE,
            self::VALUE_STUDENT_ID_BIRTH_DATE_SCHOOL_GRADE,
            self::VALUE_STUDENT_ID_BIRTH_DATE_SCHOOL_STREET_NO,
            self::VALUE_ALTERNATE_ID_PIN,
            self::VALUE_ALTERNATE_ID_SCHOOL_GRADE_STREET_NO,
            self::VALUE_ALTERNATE_ID_BIRTH_DATE_SCHOOL_GRADE,
            self::VALUE_ALTERNATE_ID_BIRTH_DATE_SCHOOL_STREET_NO,
            self::VALUE_PIN_RETRIEVAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
