<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfZoneType ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfZoneType
 * @subpackage Arrays
 */
class ArrayOfZoneType extends AbstractStructArrayBase
{
    /**
     * The ZoneType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ZoneType[]
     */
    public $ZoneType;
    /**
     * Constructor method for ArrayOfZoneType
     * @uses ArrayOfZoneType::setZoneType()
     * @param \StructType\ZoneType[] $zoneType
     */
    public function __construct(array $zoneType = array())
    {
        $this
            ->setZoneType($zoneType);
    }
    /**
     * Get ZoneType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ZoneType[]|null
     */
    public function getZoneType()
    {
        return isset($this->ZoneType) ? $this->ZoneType : null;
    }
    /**
     * Set ZoneType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ZoneType[] $zoneType
     * @return \ArrayType\ArrayOfZoneType
     */
    public function setZoneType(array $zoneType = array())
    {
        foreach ($zoneType as $arrayOfZoneTypeZoneTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfZoneTypeZoneTypeItem instanceof \StructType\ZoneType) {
                throw new \InvalidArgumentException(sprintf('The ZoneType property can only contain items of \StructType\ZoneType, "%s" given', is_object($arrayOfZoneTypeZoneTypeItem) ? get_class($arrayOfZoneTypeZoneTypeItem) : gettype($arrayOfZoneTypeZoneTypeItem)), __LINE__);
            }
        }
        if (is_null($zoneType) || (is_array($zoneType) && empty($zoneType))) {
            unset($this->ZoneType);
        } else {
            $this->ZoneType = $zoneType;
        }
        return $this;
    }
    /**
     * Add item to ZoneType value
     * @throws \InvalidArgumentException
     * @param \StructType\ZoneType $item
     * @return \ArrayType\ArrayOfZoneType
     */
    public function addToZoneType(\StructType\ZoneType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ZoneType) {
            throw new \InvalidArgumentException(sprintf('The ZoneType property can only contain items of \StructType\ZoneType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ZoneType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ZoneType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ZoneType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ZoneType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ZoneType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ZoneType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ZoneType
     */
    public function getAttributeName()
    {
        return 'ZoneType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfZoneType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
