<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfZone ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfZone
 * @subpackage Arrays
 */
class ArrayOfZone extends AbstractStructArrayBase
{
    /**
     * The Zone
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Zone[]
     */
    public $Zone;
    /**
     * Constructor method for ArrayOfZone
     * @uses ArrayOfZone::setZone()
     * @param \StructType\Zone[] $zone
     */
    public function __construct(array $zone = array())
    {
        $this
            ->setZone($zone);
    }
    /**
     * Get Zone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Zone[]|null
     */
    public function getZone()
    {
        return isset($this->Zone) ? $this->Zone : null;
    }
    /**
     * Set Zone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Zone[] $zone
     * @return \ArrayType\ArrayOfZone
     */
    public function setZone(array $zone = array())
    {
        foreach ($zone as $arrayOfZoneZoneItem) {
            // validation for constraint: itemType
            if (!$arrayOfZoneZoneItem instanceof \StructType\Zone) {
                throw new \InvalidArgumentException(sprintf('The Zone property can only contain items of \StructType\Zone, "%s" given', is_object($arrayOfZoneZoneItem) ? get_class($arrayOfZoneZoneItem) : gettype($arrayOfZoneZoneItem)), __LINE__);
            }
        }
        if (is_null($zone) || (is_array($zone) && empty($zone))) {
            unset($this->Zone);
        } else {
            $this->Zone = $zone;
        }
        return $this;
    }
    /**
     * Add item to Zone value
     * @throws \InvalidArgumentException
     * @param \StructType\Zone $item
     * @return \ArrayType\ArrayOfZone
     */
    public function addToZone(\StructType\Zone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zone) {
            throw new \InvalidArgumentException(sprintf('The Zone property can only contain items of \StructType\Zone, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Zone[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Zone|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Zone|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Zone|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Zone|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Zone|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Zone
     */
    public function getAttributeName()
    {
        return 'Zone';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfZone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
