<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWayPoint ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfWayPoint
 * @subpackage Arrays
 */
class ArrayOfWayPoint extends AbstractStructArrayBase
{
    /**
     * The WayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WayPoint[]
     */
    public $WayPoint;
    /**
     * Constructor method for ArrayOfWayPoint
     * @uses ArrayOfWayPoint::setWayPoint()
     * @param \StructType\WayPoint[] $wayPoint
     */
    public function __construct(array $wayPoint = array())
    {
        $this
            ->setWayPoint($wayPoint);
    }
    /**
     * Get WayPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WayPoint[]|null
     */
    public function getWayPoint()
    {
        return isset($this->WayPoint) ? $this->WayPoint : null;
    }
    /**
     * Set WayPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WayPoint[] $wayPoint
     * @return \ArrayType\ArrayOfWayPoint
     */
    public function setWayPoint(array $wayPoint = array())
    {
        foreach ($wayPoint as $arrayOfWayPointWayPointItem) {
            // validation for constraint: itemType
            if (!$arrayOfWayPointWayPointItem instanceof \StructType\WayPoint) {
                throw new \InvalidArgumentException(sprintf('The WayPoint property can only contain items of \StructType\WayPoint, "%s" given', is_object($arrayOfWayPointWayPointItem) ? get_class($arrayOfWayPointWayPointItem) : gettype($arrayOfWayPointWayPointItem)), __LINE__);
            }
        }
        if (is_null($wayPoint) || (is_array($wayPoint) && empty($wayPoint))) {
            unset($this->WayPoint);
        } else {
            $this->WayPoint = $wayPoint;
        }
        return $this;
    }
    /**
     * Add item to WayPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\WayPoint $item
     * @return \ArrayType\ArrayOfWayPoint
     */
    public function addToWayPoint(\StructType\WayPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WayPoint) {
            throw new \InvalidArgumentException(sprintf('The WayPoint property can only contain items of \StructType\WayPoint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WayPoint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WayPoint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WayPoint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WayPoint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WayPoint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WayPoint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WayPoint
     */
    public function getAttributeName()
    {
        return 'WayPoint';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfWayPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
