<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVehicleType ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfVehicleType
 * @subpackage Arrays
 */
class ArrayOfVehicleType extends AbstractStructArrayBase
{
    /**
     * The VehicleType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VehicleType[]
     */
    public $VehicleType;
    /**
     * Constructor method for ArrayOfVehicleType
     * @uses ArrayOfVehicleType::setVehicleType()
     * @param \StructType\VehicleType[] $vehicleType
     */
    public function __construct(array $vehicleType = array())
    {
        $this
            ->setVehicleType($vehicleType);
    }
    /**
     * Get VehicleType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VehicleType[]|null
     */
    public function getVehicleType()
    {
        return isset($this->VehicleType) ? $this->VehicleType : null;
    }
    /**
     * Set VehicleType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleType[] $vehicleType
     * @return \ArrayType\ArrayOfVehicleType
     */
    public function setVehicleType(array $vehicleType = array())
    {
        foreach ($vehicleType as $arrayOfVehicleTypeVehicleTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfVehicleTypeVehicleTypeItem instanceof \StructType\VehicleType) {
                throw new \InvalidArgumentException(sprintf('The VehicleType property can only contain items of \StructType\VehicleType, "%s" given', is_object($arrayOfVehicleTypeVehicleTypeItem) ? get_class($arrayOfVehicleTypeVehicleTypeItem) : gettype($arrayOfVehicleTypeVehicleTypeItem)), __LINE__);
            }
        }
        if (is_null($vehicleType) || (is_array($vehicleType) && empty($vehicleType))) {
            unset($this->VehicleType);
        } else {
            $this->VehicleType = $vehicleType;
        }
        return $this;
    }
    /**
     * Add item to VehicleType value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleType $item
     * @return \ArrayType\ArrayOfVehicleType
     */
    public function addToVehicleType(\StructType\VehicleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleType) {
            throw new \InvalidArgumentException(sprintf('The VehicleType property can only contain items of \StructType\VehicleType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\VehicleType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\VehicleType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\VehicleType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\VehicleType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\VehicleType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string VehicleType
     */
    public function getAttributeName()
    {
        return 'VehicleType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfVehicleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
