<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStreet ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfStreet
 * @subpackage Arrays
 */
class ArrayOfStreet extends AbstractStructArrayBase
{
    /**
     * The Street
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Street[]
     */
    public $Street;
    /**
     * Constructor method for ArrayOfStreet
     * @uses ArrayOfStreet::setStreet()
     * @param \StructType\Street[] $street
     */
    public function __construct(array $street = array())
    {
        $this
            ->setStreet($street);
    }
    /**
     * Get Street value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Street[]|null
     */
    public function getStreet()
    {
        return isset($this->Street) ? $this->Street : null;
    }
    /**
     * Set Street value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Street[] $street
     * @return \ArrayType\ArrayOfStreet
     */
    public function setStreet(array $street = array())
    {
        foreach ($street as $arrayOfStreetStreetItem) {
            // validation for constraint: itemType
            if (!$arrayOfStreetStreetItem instanceof \StructType\Street) {
                throw new \InvalidArgumentException(sprintf('The Street property can only contain items of \StructType\Street, "%s" given', is_object($arrayOfStreetStreetItem) ? get_class($arrayOfStreetStreetItem) : gettype($arrayOfStreetStreetItem)), __LINE__);
            }
        }
        if (is_null($street) || (is_array($street) && empty($street))) {
            unset($this->Street);
        } else {
            $this->Street = $street;
        }
        return $this;
    }
    /**
     * Add item to Street value
     * @throws \InvalidArgumentException
     * @param \StructType\Street $item
     * @return \ArrayType\ArrayOfStreet
     */
    public function addToStreet(\StructType\Street $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Street) {
            throw new \InvalidArgumentException(sprintf('The Street property can only contain items of \StructType\Street, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Street[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Street|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Street|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Street|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Street|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Street|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Street
     */
    public function getAttributeName()
    {
        return 'Street';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfStreet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
