<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStaff ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfStaff
 * @subpackage Arrays
 */
class ArrayOfStaff extends AbstractStructArrayBase
{
    /**
     * The Staff
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Staff[]
     */
    public $Staff;
    /**
     * Constructor method for ArrayOfStaff
     * @uses ArrayOfStaff::setStaff()
     * @param \StructType\Staff[] $staff
     */
    public function __construct(array $staff = array())
    {
        $this
            ->setStaff($staff);
    }
    /**
     * Get Staff value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Staff[]|null
     */
    public function getStaff()
    {
        return isset($this->Staff) ? $this->Staff : null;
    }
    /**
     * Set Staff value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Staff[] $staff
     * @return \ArrayType\ArrayOfStaff
     */
    public function setStaff(array $staff = array())
    {
        foreach ($staff as $arrayOfStaffStaffItem) {
            // validation for constraint: itemType
            if (!$arrayOfStaffStaffItem instanceof \StructType\Staff) {
                throw new \InvalidArgumentException(sprintf('The Staff property can only contain items of \StructType\Staff, "%s" given', is_object($arrayOfStaffStaffItem) ? get_class($arrayOfStaffStaffItem) : gettype($arrayOfStaffStaffItem)), __LINE__);
            }
        }
        if (is_null($staff) || (is_array($staff) && empty($staff))) {
            unset($this->Staff);
        } else {
            $this->Staff = $staff;
        }
        return $this;
    }
    /**
     * Add item to Staff value
     * @throws \InvalidArgumentException
     * @param \StructType\Staff $item
     * @return \ArrayType\ArrayOfStaff
     */
    public function addToStaff(\StructType\Staff $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Staff) {
            throw new \InvalidArgumentException(sprintf('The Staff property can only contain items of \StructType\Staff, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Staff[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Staff|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Staff|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Staff|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Staff|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Staff|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Staff
     */
    public function getAttributeName()
    {
        return 'Staff';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfStaff
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
