<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSchoolGrade ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSchoolGrade
 * @subpackage Arrays
 */
class ArrayOfSchoolGrade extends AbstractStructArrayBase
{
    /**
     * The SchoolGrade
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SchoolGrade[]
     */
    public $SchoolGrade;
    /**
     * Constructor method for ArrayOfSchoolGrade
     * @uses ArrayOfSchoolGrade::setSchoolGrade()
     * @param \StructType\SchoolGrade[] $schoolGrade
     */
    public function __construct(array $schoolGrade = array())
    {
        $this
            ->setSchoolGrade($schoolGrade);
    }
    /**
     * Get SchoolGrade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SchoolGrade[]|null
     */
    public function getSchoolGrade()
    {
        return isset($this->SchoolGrade) ? $this->SchoolGrade : null;
    }
    /**
     * Set SchoolGrade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SchoolGrade[] $schoolGrade
     * @return \ArrayType\ArrayOfSchoolGrade
     */
    public function setSchoolGrade(array $schoolGrade = array())
    {
        foreach ($schoolGrade as $arrayOfSchoolGradeSchoolGradeItem) {
            // validation for constraint: itemType
            if (!$arrayOfSchoolGradeSchoolGradeItem instanceof \StructType\SchoolGrade) {
                throw new \InvalidArgumentException(sprintf('The SchoolGrade property can only contain items of \StructType\SchoolGrade, "%s" given', is_object($arrayOfSchoolGradeSchoolGradeItem) ? get_class($arrayOfSchoolGradeSchoolGradeItem) : gettype($arrayOfSchoolGradeSchoolGradeItem)), __LINE__);
            }
        }
        if (is_null($schoolGrade) || (is_array($schoolGrade) && empty($schoolGrade))) {
            unset($this->SchoolGrade);
        } else {
            $this->SchoolGrade = $schoolGrade;
        }
        return $this;
    }
    /**
     * Add item to SchoolGrade value
     * @throws \InvalidArgumentException
     * @param \StructType\SchoolGrade $item
     * @return \ArrayType\ArrayOfSchoolGrade
     */
    public function addToSchoolGrade(\StructType\SchoolGrade $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SchoolGrade) {
            throw new \InvalidArgumentException(sprintf('The SchoolGrade property can only contain items of \StructType\SchoolGrade, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SchoolGrade[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SchoolGrade|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SchoolGrade|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SchoolGrade|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SchoolGrade|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SchoolGrade|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SchoolGrade
     */
    public function getAttributeName()
    {
        return 'SchoolGrade';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSchoolGrade
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
