<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRouteElement ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRouteElement
 * @subpackage Arrays
 */
class ArrayOfRouteElement extends AbstractStructArrayBase
{
    /**
     * The RouteElement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RouteElement[]
     */
    public $RouteElement;
    /**
     * Constructor method for ArrayOfRouteElement
     * @uses ArrayOfRouteElement::setRouteElement()
     * @param \StructType\RouteElement[] $routeElement
     */
    public function __construct(array $routeElement = array())
    {
        $this
            ->setRouteElement($routeElement);
    }
    /**
     * Get RouteElement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RouteElement[]|null
     */
    public function getRouteElement()
    {
        return isset($this->RouteElement) ? $this->RouteElement : null;
    }
    /**
     * Set RouteElement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RouteElement[] $routeElement
     * @return \ArrayType\ArrayOfRouteElement
     */
    public function setRouteElement(array $routeElement = array())
    {
        foreach ($routeElement as $arrayOfRouteElementRouteElementItem) {
            // validation for constraint: itemType
            if (!$arrayOfRouteElementRouteElementItem instanceof \StructType\RouteElement) {
                throw new \InvalidArgumentException(sprintf('The RouteElement property can only contain items of \StructType\RouteElement, "%s" given', is_object($arrayOfRouteElementRouteElementItem) ? get_class($arrayOfRouteElementRouteElementItem) : gettype($arrayOfRouteElementRouteElementItem)), __LINE__);
            }
        }
        if (is_null($routeElement) || (is_array($routeElement) && empty($routeElement))) {
            unset($this->RouteElement);
        } else {
            $this->RouteElement = $routeElement;
        }
        return $this;
    }
    /**
     * Add item to RouteElement value
     * @throws \InvalidArgumentException
     * @param \StructType\RouteElement $item
     * @return \ArrayType\ArrayOfRouteElement
     */
    public function addToRouteElement(\StructType\RouteElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RouteElement) {
            throw new \InvalidArgumentException(sprintf('The RouteElement property can only contain items of \StructType\RouteElement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RouteElement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RouteElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RouteElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RouteElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RouteElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RouteElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RouteElement
     */
    public function getAttributeName()
    {
        return 'RouteElement';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRouteElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
