<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPosition ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPosition
 * @subpackage Arrays
 */
class ArrayOfPosition extends AbstractStructArrayBase
{
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Position[]
     */
    public $Position;
    /**
     * Constructor method for ArrayOfPosition
     * @uses ArrayOfPosition::setPosition()
     * @param \StructType\Position[] $position
     */
    public function __construct(array $position = array())
    {
        $this
            ->setPosition($position);
    }
    /**
     * Get Position value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Position[]|null
     */
    public function getPosition()
    {
        return isset($this->Position) ? $this->Position : null;
    }
    /**
     * Set Position value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Position[] $position
     * @return \ArrayType\ArrayOfPosition
     */
    public function setPosition(array $position = array())
    {
        foreach ($position as $arrayOfPositionPositionItem) {
            // validation for constraint: itemType
            if (!$arrayOfPositionPositionItem instanceof \StructType\Position) {
                throw new \InvalidArgumentException(sprintf('The Position property can only contain items of \StructType\Position, "%s" given', is_object($arrayOfPositionPositionItem) ? get_class($arrayOfPositionPositionItem) : gettype($arrayOfPositionPositionItem)), __LINE__);
            }
        }
        if (is_null($position) || (is_array($position) && empty($position))) {
            unset($this->Position);
        } else {
            $this->Position = $position;
        }
        return $this;
    }
    /**
     * Add item to Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position $item
     * @return \ArrayType\ArrayOfPosition
     */
    public function addToPosition(\StructType\Position $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Position) {
            throw new \InvalidArgumentException(sprintf('The Position property can only contain items of \StructType\Position, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Position[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Position|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Position|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Position|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Position|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Position|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Position
     */
    public function getAttributeName()
    {
        return 'Position';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPosition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
