<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLocation ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLocation
 * @subpackage Arrays
 */
class ArrayOfLocation extends AbstractStructArrayBase
{
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Location[]
     */
    public $Location;
    /**
     * Constructor method for ArrayOfLocation
     * @uses ArrayOfLocation::setLocation()
     * @param \StructType\Location[] $location
     */
    public function __construct(array $location = array())
    {
        $this
            ->setLocation($location);
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Location[]|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Location[] $location
     * @return \ArrayType\ArrayOfLocation
     */
    public function setLocation(array $location = array())
    {
        foreach ($location as $arrayOfLocationLocationItem) {
            // validation for constraint: itemType
            if (!$arrayOfLocationLocationItem instanceof \StructType\Location) {
                throw new \InvalidArgumentException(sprintf('The Location property can only contain items of \StructType\Location, "%s" given', is_object($arrayOfLocationLocationItem) ? get_class($arrayOfLocationLocationItem) : gettype($arrayOfLocationLocationItem)), __LINE__);
            }
        }
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Add item to Location value
     * @throws \InvalidArgumentException
     * @param \StructType\Location $item
     * @return \ArrayType\ArrayOfLocation
     */
    public function addToLocation(\StructType\Location $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Location) {
            throw new \InvalidArgumentException(sprintf('The Location property can only contain items of \StructType\Location, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Location[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Location|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Location|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Location|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Location|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Location|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Location
     */
    public function getAttributeName()
    {
        return 'Location';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
