<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDistrict ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDistrict
 * @subpackage Arrays
 */
class ArrayOfDistrict extends AbstractStructArrayBase
{
    /**
     * The District
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\District[]
     */
    public $District;
    /**
     * Constructor method for ArrayOfDistrict
     * @uses ArrayOfDistrict::setDistrict()
     * @param \StructType\District[] $district
     */
    public function __construct(array $district = array())
    {
        $this
            ->setDistrict($district);
    }
    /**
     * Get District value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\District[]|null
     */
    public function getDistrict()
    {
        return isset($this->District) ? $this->District : null;
    }
    /**
     * Set District value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\District[] $district
     * @return \ArrayType\ArrayOfDistrict
     */
    public function setDistrict(array $district = array())
    {
        foreach ($district as $arrayOfDistrictDistrictItem) {
            // validation for constraint: itemType
            if (!$arrayOfDistrictDistrictItem instanceof \StructType\District) {
                throw new \InvalidArgumentException(sprintf('The District property can only contain items of \StructType\District, "%s" given', is_object($arrayOfDistrictDistrictItem) ? get_class($arrayOfDistrictDistrictItem) : gettype($arrayOfDistrictDistrictItem)), __LINE__);
            }
        }
        if (is_null($district) || (is_array($district) && empty($district))) {
            unset($this->District);
        } else {
            $this->District = $district;
        }
        return $this;
    }
    /**
     * Add item to District value
     * @throws \InvalidArgumentException
     * @param \StructType\District $item
     * @return \ArrayType\ArrayOfDistrict
     */
    public function addToDistrict(\StructType\District $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\District) {
            throw new \InvalidArgumentException(sprintf('The District property can only contain items of \StructType\District, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->District[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\District|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\District|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\District|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\District|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\District|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string District
     */
    public function getAttributeName()
    {
        return 'District';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDistrict
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
