<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccessPoint ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAccessPoint
 * @subpackage Arrays
 */
class ArrayOfAccessPoint extends AbstractStructArrayBase
{
    /**
     * The AccessPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccessPoint[]
     */
    public $AccessPoint;
    /**
     * Constructor method for ArrayOfAccessPoint
     * @uses ArrayOfAccessPoint::setAccessPoint()
     * @param \StructType\AccessPoint[] $accessPoint
     */
    public function __construct(array $accessPoint = array())
    {
        $this
            ->setAccessPoint($accessPoint);
    }
    /**
     * Get AccessPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccessPoint[]|null
     */
    public function getAccessPoint()
    {
        return isset($this->AccessPoint) ? $this->AccessPoint : null;
    }
    /**
     * Set AccessPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccessPoint[] $accessPoint
     * @return \ArrayType\ArrayOfAccessPoint
     */
    public function setAccessPoint(array $accessPoint = array())
    {
        foreach ($accessPoint as $arrayOfAccessPointAccessPointItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccessPointAccessPointItem instanceof \StructType\AccessPoint) {
                throw new \InvalidArgumentException(sprintf('The AccessPoint property can only contain items of \StructType\AccessPoint, "%s" given', is_object($arrayOfAccessPointAccessPointItem) ? get_class($arrayOfAccessPointAccessPointItem) : gettype($arrayOfAccessPointAccessPointItem)), __LINE__);
            }
        }
        if (is_null($accessPoint) || (is_array($accessPoint) && empty($accessPoint))) {
            unset($this->AccessPoint);
        } else {
            $this->AccessPoint = $accessPoint;
        }
        return $this;
    }
    /**
     * Add item to AccessPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessPoint $item
     * @return \ArrayType\ArrayOfAccessPoint
     */
    public function addToAccessPoint(\StructType\AccessPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccessPoint) {
            throw new \InvalidArgumentException(sprintf('The AccessPoint property can only contain items of \StructType\AccessPoint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccessPoint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AccessPoint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AccessPoint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AccessPoint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AccessPoint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AccessPoint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccessPoint
     */
    public function getAttributeName()
    {
        return 'AccessPoint';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAccessPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
