<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WayPoint StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WayPoint
 * @subpackage Structs
 */
class WayPoint extends AbstractStructBase
{
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The BusStopID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BusStopID;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Distance;
    /**
     * The EndTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EndTime;
    /**
     * The Heading
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Heading;
    /**
     * The Latitude
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * @var float
     */
    public $Longitude;
    /**
     * The Municipality
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Municipality;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The RouteID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RouteID;
    /**
     * The RunID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RunID;
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StartTime;
    /**
     * The Street
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Street;
    /**
     * The X
     * @var float
     */
    public $X;
    /**
     * The Y
     * @var float
     */
    public $Y;
    /**
     * Constructor method for WayPoint
     * @uses WayPoint::setAction()
     * @uses WayPoint::setBusStopID()
     * @uses WayPoint::setDistance()
     * @uses WayPoint::setEndTime()
     * @uses WayPoint::setHeading()
     * @uses WayPoint::setLatitude()
     * @uses WayPoint::setLongitude()
     * @uses WayPoint::setMunicipality()
     * @uses WayPoint::setOrder()
     * @uses WayPoint::setRouteID()
     * @uses WayPoint::setRunID()
     * @uses WayPoint::setStartTime()
     * @uses WayPoint::setStreet()
     * @uses WayPoint::setX()
     * @uses WayPoint::setY()
     * @param string $action
     * @param string $busStopID
     * @param string $distance
     * @param string $endTime
     * @param string $heading
     * @param float $latitude
     * @param float $longitude
     * @param string $municipality
     * @param int $order
     * @param string $routeID
     * @param string $runID
     * @param string $startTime
     * @param string $street
     * @param float $x
     * @param float $y
     */
    public function __construct($action = null, $busStopID = null, $distance = null, $endTime = null, $heading = null, $latitude = null, $longitude = null, $municipality = null, $order = null, $routeID = null, $runID = null, $startTime = null, $street = null, $x = null, $y = null)
    {
        $this
            ->setAction($action)
            ->setBusStopID($busStopID)
            ->setDistance($distance)
            ->setEndTime($endTime)
            ->setHeading($heading)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setMunicipality($municipality)
            ->setOrder($order)
            ->setRouteID($routeID)
            ->setRunID($runID)
            ->setStartTime($startTime)
            ->setStreet($street)
            ->setX($x)
            ->setY($y);
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param string $action
     * @return \StructType\WayPoint
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($action)), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get BusStopID value
     * @return string|null
     */
    public function getBusStopID()
    {
        return $this->BusStopID;
    }
    /**
     * Set BusStopID value
     * @param string $busStopID
     * @return \StructType\WayPoint
     */
    public function setBusStopID($busStopID = null)
    {
        // validation for constraint: string
        if (!is_null($busStopID) && !is_string($busStopID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($busStopID)), __LINE__);
        }
        $this->BusStopID = $busStopID;
        return $this;
    }
    /**
     * Get Distance value
     * @return string|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param string $distance
     * @return \StructType\WayPoint
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: string
        if (!is_null($distance) && !is_string($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \StructType\WayPoint
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Get Heading value
     * @return string|null
     */
    public function getHeading()
    {
        return $this->Heading;
    }
    /**
     * Set Heading value
     * @param string $heading
     * @return \StructType\WayPoint
     */
    public function setHeading($heading = null)
    {
        // validation for constraint: string
        if (!is_null($heading) && !is_string($heading)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($heading)), __LINE__);
        }
        $this->Heading = $heading;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\WayPoint
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\WayPoint
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Municipality value
     * @return string|null
     */
    public function getMunicipality()
    {
        return $this->Municipality;
    }
    /**
     * Set Municipality value
     * @param string $municipality
     * @return \StructType\WayPoint
     */
    public function setMunicipality($municipality = null)
    {
        // validation for constraint: string
        if (!is_null($municipality) && !is_string($municipality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($municipality)), __LINE__);
        }
        $this->Municipality = $municipality;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\WayPoint
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get RouteID value
     * @return string|null
     */
    public function getRouteID()
    {
        return $this->RouteID;
    }
    /**
     * Set RouteID value
     * @param string $routeID
     * @return \StructType\WayPoint
     */
    public function setRouteID($routeID = null)
    {
        // validation for constraint: string
        if (!is_null($routeID) && !is_string($routeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeID)), __LINE__);
        }
        $this->RouteID = $routeID;
        return $this;
    }
    /**
     * Get RunID value
     * @return string|null
     */
    public function getRunID()
    {
        return $this->RunID;
    }
    /**
     * Set RunID value
     * @param string $runID
     * @return \StructType\WayPoint
     */
    public function setRunID($runID = null)
    {
        // validation for constraint: string
        if (!is_null($runID) && !is_string($runID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runID)), __LINE__);
        }
        $this->RunID = $runID;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\WayPoint
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \StructType\WayPoint
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get X value
     * @return float|null
     */
    public function getX()
    {
        return $this->X;
    }
    /**
     * Set X value
     * @param float $x
     * @return \StructType\WayPoint
     */
    public function setX($x = null)
    {
        $this->X = $x;
        return $this;
    }
    /**
     * Get Y value
     * @return float|null
     */
    public function getY()
    {
        return $this->Y;
    }
    /**
     * Set Y value
     * @param float $y
     * @return \StructType\WayPoint
     */
    public function setY($y = null)
    {
        $this->Y = $y;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WayPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
