<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleType StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:VehicleType
 * @subpackage Structs
 */
class VehicleType extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The FuelTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FuelTypeGuid;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The RegularSeats
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RegularSeats;
    /**
     * The Size
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Size;
    /**
     * The TotalSeats
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotalSeats;
    /**
     * The VehicleClassificationGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VehicleClassificationGuid;
    /**
     * The VehicleTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VehicleTypeGuid;
    /**
     * The WheelchairSeats
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WheelchairSeats;
    /**
     * Constructor method for VehicleType
     * @uses VehicleType::setDescription()
     * @uses VehicleType::setFuelTypeGuid()
     * @uses VehicleType::setName()
     * @uses VehicleType::setRegularSeats()
     * @uses VehicleType::setSize()
     * @uses VehicleType::setTotalSeats()
     * @uses VehicleType::setVehicleClassificationGuid()
     * @uses VehicleType::setVehicleTypeGuid()
     * @uses VehicleType::setWheelchairSeats()
     * @param string $description
     * @param string $fuelTypeGuid
     * @param string $name
     * @param int $regularSeats
     * @param int $size
     * @param int $totalSeats
     * @param string $vehicleClassificationGuid
     * @param string $vehicleTypeGuid
     * @param int $wheelchairSeats
     */
    public function __construct($description = null, $fuelTypeGuid = null, $name = null, $regularSeats = null, $size = null, $totalSeats = null, $vehicleClassificationGuid = null, $vehicleTypeGuid = null, $wheelchairSeats = null)
    {
        $this
            ->setDescription($description)
            ->setFuelTypeGuid($fuelTypeGuid)
            ->setName($name)
            ->setRegularSeats($regularSeats)
            ->setSize($size)
            ->setTotalSeats($totalSeats)
            ->setVehicleClassificationGuid($vehicleClassificationGuid)
            ->setVehicleTypeGuid($vehicleTypeGuid)
            ->setWheelchairSeats($wheelchairSeats);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\VehicleType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get FuelTypeGuid value
     * @return string|null
     */
    public function getFuelTypeGuid()
    {
        return $this->FuelTypeGuid;
    }
    /**
     * Set FuelTypeGuid value
     * @param string $fuelTypeGuid
     * @return \StructType\VehicleType
     */
    public function setFuelTypeGuid($fuelTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($fuelTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fuelTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($fuelTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fuelTypeGuid) && !is_string($fuelTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fuelTypeGuid)), __LINE__);
        }
        $this->FuelTypeGuid = $fuelTypeGuid;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\VehicleType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get RegularSeats value
     * @return int|null
     */
    public function getRegularSeats()
    {
        return $this->RegularSeats;
    }
    /**
     * Set RegularSeats value
     * @param int $regularSeats
     * @return \StructType\VehicleType
     */
    public function setRegularSeats($regularSeats = null)
    {
        // validation for constraint: int
        if (!is_null($regularSeats) && !is_numeric($regularSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($regularSeats)), __LINE__);
        }
        $this->RegularSeats = $regularSeats;
        return $this;
    }
    /**
     * Get Size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param int $size
     * @return \StructType\VehicleType
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !is_numeric($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
    /**
     * Get TotalSeats value
     * @return int|null
     */
    public function getTotalSeats()
    {
        return $this->TotalSeats;
    }
    /**
     * Set TotalSeats value
     * @param int $totalSeats
     * @return \StructType\VehicleType
     */
    public function setTotalSeats($totalSeats = null)
    {
        // validation for constraint: int
        if (!is_null($totalSeats) && !is_numeric($totalSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalSeats)), __LINE__);
        }
        $this->TotalSeats = $totalSeats;
        return $this;
    }
    /**
     * Get VehicleClassificationGuid value
     * @return string|null
     */
    public function getVehicleClassificationGuid()
    {
        return $this->VehicleClassificationGuid;
    }
    /**
     * Set VehicleClassificationGuid value
     * @param string $vehicleClassificationGuid
     * @return \StructType\VehicleType
     */
    public function setVehicleClassificationGuid($vehicleClassificationGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($vehicleClassificationGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $vehicleClassificationGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($vehicleClassificationGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vehicleClassificationGuid) && !is_string($vehicleClassificationGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleClassificationGuid)), __LINE__);
        }
        $this->VehicleClassificationGuid = $vehicleClassificationGuid;
        return $this;
    }
    /**
     * Get VehicleTypeGuid value
     * @return string|null
     */
    public function getVehicleTypeGuid()
    {
        return $this->VehicleTypeGuid;
    }
    /**
     * Set VehicleTypeGuid value
     * @param string $vehicleTypeGuid
     * @return \StructType\VehicleType
     */
    public function setVehicleTypeGuid($vehicleTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($vehicleTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $vehicleTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($vehicleTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vehicleTypeGuid) && !is_string($vehicleTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleTypeGuid)), __LINE__);
        }
        $this->VehicleTypeGuid = $vehicleTypeGuid;
        return $this;
    }
    /**
     * Get WheelchairSeats value
     * @return int|null
     */
    public function getWheelchairSeats()
    {
        return $this->WheelchairSeats;
    }
    /**
     * Set WheelchairSeats value
     * @param int $wheelchairSeats
     * @return \StructType\VehicleType
     */
    public function setWheelchairSeats($wheelchairSeats = null)
    {
        // validation for constraint: int
        if (!is_null($wheelchairSeats) && !is_numeric($wheelchairSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($wheelchairSeats)), __LINE__);
        }
        $this->WheelchairSeats = $wheelchairSeats;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
