<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vehicle StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Vehicle
 * @subpackage Structs
 */
class Vehicle extends AbstractStructBase
{
    /**
     * The Active
     * @var bool
     */
    public $Active;
    /**
     * The Classification
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Classification;
    /**
     * The DepotId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DepotId;
    /**
     * The OperatorID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OperatorID;
    /**
     * The VehicleGuid
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VehicleGuid;
    /**
     * The VehicleID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $VehicleID;
    /**
     * The License
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $License;
    /**
     * The Make
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Make;
    /**
     * The Model
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Model;
    /**
     * The ModelYear
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModelYear;
    /**
     * The OperatorGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OperatorGuid;
    /**
     * The VehicleTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VehicleTypeGuid;
    /**
     * Constructor method for Vehicle
     * @uses Vehicle::setActive()
     * @uses Vehicle::setClassification()
     * @uses Vehicle::setDepotId()
     * @uses Vehicle::setOperatorID()
     * @uses Vehicle::setVehicleGuid()
     * @uses Vehicle::setVehicleID()
     * @uses Vehicle::setLicense()
     * @uses Vehicle::setMake()
     * @uses Vehicle::setModel()
     * @uses Vehicle::setModelYear()
     * @uses Vehicle::setOperatorGuid()
     * @uses Vehicle::setVehicleTypeGuid()
     * @param bool $active
     * @param string $classification
     * @param string $depotId
     * @param string $operatorID
     * @param string $vehicleGuid
     * @param string $vehicleID
     * @param string $license
     * @param string $make
     * @param string $model
     * @param string $modelYear
     * @param string $operatorGuid
     * @param string $vehicleTypeGuid
     */
    public function __construct($active = null, $classification = null, $depotId = null, $operatorID = null, $vehicleGuid = null, $vehicleID = null, $license = null, $make = null, $model = null, $modelYear = null, $operatorGuid = null, $vehicleTypeGuid = null)
    {
        $this
            ->setActive($active)
            ->setClassification($classification)
            ->setDepotId($depotId)
            ->setOperatorID($operatorID)
            ->setVehicleGuid($vehicleGuid)
            ->setVehicleID($vehicleID)
            ->setLicense($license)
            ->setMake($make)
            ->setModel($model)
            ->setModelYear($modelYear)
            ->setOperatorGuid($operatorGuid)
            ->setVehicleTypeGuid($vehicleTypeGuid);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Vehicle
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Classification value
     * @return string|null
     */
    public function getClassification()
    {
        return $this->Classification;
    }
    /**
     * Set Classification value
     * @param string $classification
     * @return \StructType\Vehicle
     */
    public function setClassification($classification = null)
    {
        // validation for constraint: string
        if (!is_null($classification) && !is_string($classification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($classification)), __LINE__);
        }
        $this->Classification = $classification;
        return $this;
    }
    /**
     * Get DepotId value
     * @return string|null
     */
    public function getDepotId()
    {
        return $this->DepotId;
    }
    /**
     * Set DepotId value
     * @param string $depotId
     * @return \StructType\Vehicle
     */
    public function setDepotId($depotId = null)
    {
        // validation for constraint: string
        if (!is_null($depotId) && !is_string($depotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depotId)), __LINE__);
        }
        $this->DepotId = $depotId;
        return $this;
    }
    /**
     * Get OperatorID value
     * @return string|null
     */
    public function getOperatorID()
    {
        return $this->OperatorID;
    }
    /**
     * Set OperatorID value
     * @param string $operatorID
     * @return \StructType\Vehicle
     */
    public function setOperatorID($operatorID = null)
    {
        // validation for constraint: string
        if (!is_null($operatorID) && !is_string($operatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatorID)), __LINE__);
        }
        $this->OperatorID = $operatorID;
        return $this;
    }
    /**
     * Get VehicleGuid value
     * @return string|null
     */
    public function getVehicleGuid()
    {
        return $this->VehicleGuid;
    }
    /**
     * Set VehicleGuid value
     * @param string $vehicleGuid
     * @return \StructType\Vehicle
     */
    public function setVehicleGuid($vehicleGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($vehicleGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $vehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($vehicleGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vehicleGuid) && !is_string($vehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleGuid)), __LINE__);
        }
        $this->VehicleGuid = $vehicleGuid;
        return $this;
    }
    /**
     * Get VehicleID value
     * @return string|null
     */
    public function getVehicleID()
    {
        return $this->VehicleID;
    }
    /**
     * Set VehicleID value
     * @param string $vehicleID
     * @return \StructType\Vehicle
     */
    public function setVehicleID($vehicleID = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleID) && !is_string($vehicleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleID)), __LINE__);
        }
        $this->VehicleID = $vehicleID;
        return $this;
    }
    /**
     * Get License value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLicense()
    {
        return isset($this->License) ? $this->License : null;
    }
    /**
     * Set License value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $license
     * @return \StructType\Vehicle
     */
    public function setLicense($license = null)
    {
        // validation for constraint: string
        if (!is_null($license) && !is_string($license)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($license)), __LINE__);
        }
        if (is_null($license) || (is_array($license) && empty($license))) {
            unset($this->License);
        } else {
            $this->License = $license;
        }
        return $this;
    }
    /**
     * Get Make value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMake()
    {
        return isset($this->Make) ? $this->Make : null;
    }
    /**
     * Set Make value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $make
     * @return \StructType\Vehicle
     */
    public function setMake($make = null)
    {
        // validation for constraint: string
        if (!is_null($make) && !is_string($make)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($make)), __LINE__);
        }
        if (is_null($make) || (is_array($make) && empty($make))) {
            unset($this->Make);
        } else {
            $this->Make = $make;
        }
        return $this;
    }
    /**
     * Get Model value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModel()
    {
        return isset($this->Model) ? $this->Model : null;
    }
    /**
     * Set Model value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $model
     * @return \StructType\Vehicle
     */
    public function setModel($model = null)
    {
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($model)), __LINE__);
        }
        if (is_null($model) || (is_array($model) && empty($model))) {
            unset($this->Model);
        } else {
            $this->Model = $model;
        }
        return $this;
    }
    /**
     * Get ModelYear value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModelYear()
    {
        return isset($this->ModelYear) ? $this->ModelYear : null;
    }
    /**
     * Set ModelYear value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modelYear
     * @return \StructType\Vehicle
     */
    public function setModelYear($modelYear = null)
    {
        // validation for constraint: string
        if (!is_null($modelYear) && !is_string($modelYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelYear)), __LINE__);
        }
        if (is_null($modelYear) || (is_array($modelYear) && empty($modelYear))) {
            unset($this->ModelYear);
        } else {
            $this->ModelYear = $modelYear;
        }
        return $this;
    }
    /**
     * Get OperatorGuid value
     * @return string|null
     */
    public function getOperatorGuid()
    {
        return $this->OperatorGuid;
    }
    /**
     * Set OperatorGuid value
     * @param string $operatorGuid
     * @return \StructType\Vehicle
     */
    public function setOperatorGuid($operatorGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($operatorGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $operatorGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($operatorGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operatorGuid) && !is_string($operatorGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatorGuid)), __LINE__);
        }
        $this->OperatorGuid = $operatorGuid;
        return $this;
    }
    /**
     * Get VehicleTypeGuid value
     * @return string|null
     */
    public function getVehicleTypeGuid()
    {
        return $this->VehicleTypeGuid;
    }
    /**
     * Set VehicleTypeGuid value
     * @param string $vehicleTypeGuid
     * @return \StructType\Vehicle
     */
    public function setVehicleTypeGuid($vehicleTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($vehicleTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $vehicleTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($vehicleTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vehicleTypeGuid) && !is_string($vehicleTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleTypeGuid)), __LINE__);
        }
        $this->VehicleTypeGuid = $vehicleTypeGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Vehicle
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
