<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransitBasic StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TransitBasic
 * @subpackage Structs
 */
class TransitBasic extends AbstractStructBase
{
    /**
     * The Operator
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Operator;
    /**
     * The RouteID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RouteID;
    /**
     * The RunID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RunID;
    /**
     * The StopDates
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Dates
     */
    public $StopDates;
    /**
     * The StopDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StopDescription;
    /**
     * The Time
     * @var string
     */
    public $Time;
    /**
     * Constructor method for TransitBasic
     * @uses TransitBasic::setOperator()
     * @uses TransitBasic::setRouteID()
     * @uses TransitBasic::setRunID()
     * @uses TransitBasic::setStopDates()
     * @uses TransitBasic::setStopDescription()
     * @uses TransitBasic::setTime()
     * @param string $operator
     * @param string $routeID
     * @param string $runID
     * @param \StructType\Dates $stopDates
     * @param string $stopDescription
     * @param string $time
     */
    public function __construct($operator = null, $routeID = null, $runID = null, \StructType\Dates $stopDates = null, $stopDescription = null, $time = null)
    {
        $this
            ->setOperator($operator)
            ->setRouteID($routeID)
            ->setRunID($runID)
            ->setStopDates($stopDates)
            ->setStopDescription($stopDescription)
            ->setTime($time);
    }
    /**
     * Get Operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->Operator;
    }
    /**
     * Set Operator value
     * @param string $operator
     * @return \StructType\TransitBasic
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: string
        if (!is_null($operator) && !is_string($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operator)), __LINE__);
        }
        $this->Operator = $operator;
        return $this;
    }
    /**
     * Get RouteID value
     * @return string|null
     */
    public function getRouteID()
    {
        return $this->RouteID;
    }
    /**
     * Set RouteID value
     * @param string $routeID
     * @return \StructType\TransitBasic
     */
    public function setRouteID($routeID = null)
    {
        // validation for constraint: string
        if (!is_null($routeID) && !is_string($routeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeID)), __LINE__);
        }
        $this->RouteID = $routeID;
        return $this;
    }
    /**
     * Get RunID value
     * @return string|null
     */
    public function getRunID()
    {
        return $this->RunID;
    }
    /**
     * Set RunID value
     * @param string $runID
     * @return \StructType\TransitBasic
     */
    public function setRunID($runID = null)
    {
        // validation for constraint: string
        if (!is_null($runID) && !is_string($runID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runID)), __LINE__);
        }
        $this->RunID = $runID;
        return $this;
    }
    /**
     * Get StopDates value
     * @return \StructType\Dates|null
     */
    public function getStopDates()
    {
        return $this->StopDates;
    }
    /**
     * Set StopDates value
     * @param \StructType\Dates $stopDates
     * @return \StructType\TransitBasic
     */
    public function setStopDates(\StructType\Dates $stopDates = null)
    {
        $this->StopDates = $stopDates;
        return $this;
    }
    /**
     * Get StopDescription value
     * @return string|null
     */
    public function getStopDescription()
    {
        return $this->StopDescription;
    }
    /**
     * Set StopDescription value
     * @param string $stopDescription
     * @return \StructType\TransitBasic
     */
    public function setStopDescription($stopDescription = null)
    {
        // validation for constraint: string
        if (!is_null($stopDescription) && !is_string($stopDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stopDescription)), __LINE__);
        }
        $this->StopDescription = $stopDescription;
        return $this;
    }
    /**
     * Get Time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \StructType\TransitBasic
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransitBasic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
