<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StudentStop StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StudentStop
 * @subpackage Structs
 */
class StudentStop extends AbstractStructBase
{
    /**
     * The BusStopID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BusStopID;
    /**
     * The StudentID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StudentID;
    /**
     * Constructor method for StudentStop
     * @uses StudentStop::setBusStopID()
     * @uses StudentStop::setStudentID()
     * @param string $busStopID
     * @param string $studentID
     */
    public function __construct($busStopID = null, $studentID = null)
    {
        $this
            ->setBusStopID($busStopID)
            ->setStudentID($studentID);
    }
    /**
     * Get BusStopID value
     * @return string|null
     */
    public function getBusStopID()
    {
        return $this->BusStopID;
    }
    /**
     * Set BusStopID value
     * @param string $busStopID
     * @return \StructType\StudentStop
     */
    public function setBusStopID($busStopID = null)
    {
        // validation for constraint: string
        if (!is_null($busStopID) && !is_string($busStopID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($busStopID)), __LINE__);
        }
        $this->BusStopID = $busStopID;
        return $this;
    }
    /**
     * Get StudentID value
     * @return string|null
     */
    public function getStudentID()
    {
        return $this->StudentID;
    }
    /**
     * Set StudentID value
     * @param string $studentID
     * @return \StructType\StudentStop
     */
    public function setStudentID($studentID = null)
    {
        // validation for constraint: string
        if (!is_null($studentID) && !is_string($studentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($studentID)), __LINE__);
        }
        $this->StudentID = $studentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StudentStop
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
