<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StudentProgram StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StudentProgram
 * @subpackage Structs
 */
class StudentProgram extends AbstractStructBase
{
    /**
     * The Program
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Program;
    /**
     * The StudentID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StudentID;
    /**
     * Constructor method for StudentProgram
     * @uses StudentProgram::setProgram()
     * @uses StudentProgram::setStudentID()
     * @param string $program
     * @param string $studentID
     */
    public function __construct($program = null, $studentID = null)
    {
        $this
            ->setProgram($program)
            ->setStudentID($studentID);
    }
    /**
     * Get Program value
     * @return string|null
     */
    public function getProgram()
    {
        return $this->Program;
    }
    /**
     * Set Program value
     * @param string $program
     * @return \StructType\StudentProgram
     */
    public function setProgram($program = null)
    {
        // validation for constraint: string
        if (!is_null($program) && !is_string($program)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($program)), __LINE__);
        }
        $this->Program = $program;
        return $this;
    }
    /**
     * Get StudentID value
     * @return string|null
     */
    public function getStudentID()
    {
        return $this->StudentID;
    }
    /**
     * Set StudentID value
     * @param string $studentID
     * @return \StructType\StudentProgram
     */
    public function setStudentID($studentID = null)
    {
        // validation for constraint: string
        if (!is_null($studentID) && !is_string($studentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($studentID)), __LINE__);
        }
        $this->StudentID = $studentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StudentProgram
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
