<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StudentAuthenticates StructType
 * @subpackage Structs
 */
class StudentAuthenticates extends AbstractStructBase
{
    /**
     * The databaseGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $databaseGuid;
    /**
     * The authenticationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authenticationType;
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticateStudentInfo
     */
    public $info;
    /**
     * Constructor method for StudentAuthenticates
     * @uses StudentAuthenticates::setDatabaseGuid()
     * @uses StudentAuthenticates::setAuthenticationType()
     * @uses StudentAuthenticates::setInfo()
     * @param string $databaseGuid
     * @param string $authenticationType
     * @param \StructType\AuthenticateStudentInfo $info
     */
    public function __construct($databaseGuid = null, $authenticationType = null, \StructType\AuthenticateStudentInfo $info = null)
    {
        $this
            ->setDatabaseGuid($databaseGuid)
            ->setAuthenticationType($authenticationType)
            ->setInfo($info);
    }
    /**
     * Get databaseGuid value
     * @return string|null
     */
    public function getDatabaseGuid()
    {
        return $this->databaseGuid;
    }
    /**
     * Set databaseGuid value
     * @param string $databaseGuid
     * @return \StructType\StudentAuthenticates
     */
    public function setDatabaseGuid($databaseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($databaseGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($databaseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($databaseGuid) && !is_string($databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseGuid)), __LINE__);
        }
        $this->databaseGuid = $databaseGuid;
        return $this;
    }
    /**
     * Get authenticationType value
     * @return string|null
     */
    public function getAuthenticationType()
    {
        return $this->authenticationType;
    }
    /**
     * Set authenticationType value
     * @uses \EnumType\AuthenticationType::valueIsValid()
     * @uses \EnumType\AuthenticationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationType
     * @return \StructType\StudentAuthenticates
     */
    public function setAuthenticationType($authenticationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AuthenticationType::valueIsValid($authenticationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationType, implode(', ', \EnumType\AuthenticationType::getValidValues())), __LINE__);
        }
        $this->authenticationType = $authenticationType;
        return $this;
    }
    /**
     * Get info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticateStudentInfo|null
     */
    public function getInfo()
    {
        return isset($this->info) ? $this->info : null;
    }
    /**
     * Set info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticateStudentInfo $info
     * @return \StructType\StudentAuthenticates
     */
    public function setInfo(\StructType\AuthenticateStudentInfo $info = null)
    {
        if (is_null($info) || (is_array($info) && empty($info))) {
            unset($this->info);
        } else {
            $this->info = $info;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StudentAuthenticates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
