<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Street StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Street
 * @subpackage Structs
 */
class Street extends AbstractStructBase
{
    /**
     * The Municipality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Municipality;
    /**
     * The StreetName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StreetName;
    /**
     * The StreetNameGuid
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StreetNameGuid;
    /**
     * Constructor method for Street
     * @uses Street::setMunicipality()
     * @uses Street::setStreetName()
     * @uses Street::setStreetNameGuid()
     * @param string $municipality
     * @param string $streetName
     * @param string $streetNameGuid
     */
    public function __construct($municipality = null, $streetName = null, $streetNameGuid = null)
    {
        $this
            ->setMunicipality($municipality)
            ->setStreetName($streetName)
            ->setStreetNameGuid($streetNameGuid);
    }
    /**
     * Get Municipality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMunicipality()
    {
        return isset($this->Municipality) ? $this->Municipality : null;
    }
    /**
     * Set Municipality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $municipality
     * @return \StructType\Street
     */
    public function setMunicipality($municipality = null)
    {
        // validation for constraint: string
        if (!is_null($municipality) && !is_string($municipality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($municipality)), __LINE__);
        }
        if (is_null($municipality) || (is_array($municipality) && empty($municipality))) {
            unset($this->Municipality);
        } else {
            $this->Municipality = $municipality;
        }
        return $this;
    }
    /**
     * Get StreetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }
    /**
     * Set StreetName value
     * @param string $streetName
     * @return \StructType\Street
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetName)), __LINE__);
        }
        $this->StreetName = $streetName;
        return $this;
    }
    /**
     * Get StreetNameGuid value
     * @return string|null
     */
    public function getStreetNameGuid()
    {
        return $this->StreetNameGuid;
    }
    /**
     * Set StreetNameGuid value
     * @param string $streetNameGuid
     * @return \StructType\Street
     */
    public function setStreetNameGuid($streetNameGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($streetNameGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $streetNameGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($streetNameGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($streetNameGuid) && !is_string($streetNameGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetNameGuid)), __LINE__);
        }
        $this->StreetNameGuid = $streetNameGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Street
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
