<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Staff StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Staff
 * @subpackage Structs
 */
class Staff extends AbstractStructBase
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BirthDate;
    /**
     * The CellPhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CellPhone;
    /**
     * The Email1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email1;
    /**
     * The Email2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email2;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The GovernmentID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GovernmentID;
    /**
     * The HireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HireDate;
    /**
     * The HomePhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomePhone;
    /**
     * The LanguagesSpoken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LanguagesSpoken;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The License
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $License;
    /**
     * The MailingAddress1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MailingAddress1;
    /**
     * The MailingAddress2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MailingAddress2;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The OperatorGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OperatorGuid;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Position;
    /**
     * The PreferredLanguage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredLanguage;
    /**
     * The PreferredPhoneTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PreferredPhoneTypeGuid;
    /**
     * The Protected
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protected;
    /**
     * The StaffGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StaffGuid;
    /**
     * The StaffID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StaffID;
    /**
     * The WorkPhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkPhone;
    /**
     * Constructor method for Staff
     * @uses Staff::setActive()
     * @uses Staff::setBirthDate()
     * @uses Staff::setCellPhone()
     * @uses Staff::setEmail1()
     * @uses Staff::setEmail2()
     * @uses Staff::setFax()
     * @uses Staff::setFirstName()
     * @uses Staff::setGovernmentID()
     * @uses Staff::setHireDate()
     * @uses Staff::setHomePhone()
     * @uses Staff::setLanguagesSpoken()
     * @uses Staff::setLastName()
     * @uses Staff::setLicense()
     * @uses Staff::setMailingAddress1()
     * @uses Staff::setMailingAddress2()
     * @uses Staff::setNotes()
     * @uses Staff::setOperatorGuid()
     * @uses Staff::setPosition()
     * @uses Staff::setPreferredLanguage()
     * @uses Staff::setPreferredPhoneTypeGuid()
     * @uses Staff::setProtected()
     * @uses Staff::setStaffGuid()
     * @uses Staff::setStaffID()
     * @uses Staff::setWorkPhone()
     * @param bool $active
     * @param string $birthDate
     * @param string $cellPhone
     * @param string $email1
     * @param string $email2
     * @param string $fax
     * @param string $firstName
     * @param string $governmentID
     * @param string $hireDate
     * @param string $homePhone
     * @param string $languagesSpoken
     * @param string $lastName
     * @param string $license
     * @param string $mailingAddress1
     * @param string $mailingAddress2
     * @param string $notes
     * @param string $operatorGuid
     * @param string $position
     * @param string $preferredLanguage
     * @param string $preferredPhoneTypeGuid
     * @param bool $protected
     * @param string $staffGuid
     * @param string $staffID
     * @param string $workPhone
     */
    public function __construct($active = null, $birthDate = null, $cellPhone = null, $email1 = null, $email2 = null, $fax = null, $firstName = null, $governmentID = null, $hireDate = null, $homePhone = null, $languagesSpoken = null, $lastName = null, $license = null, $mailingAddress1 = null, $mailingAddress2 = null, $notes = null, $operatorGuid = null, $position = null, $preferredLanguage = null, $preferredPhoneTypeGuid = null, $protected = null, $staffGuid = null, $staffID = null, $workPhone = null)
    {
        $this
            ->setActive($active)
            ->setBirthDate($birthDate)
            ->setCellPhone($cellPhone)
            ->setEmail1($email1)
            ->setEmail2($email2)
            ->setFax($fax)
            ->setFirstName($firstName)
            ->setGovernmentID($governmentID)
            ->setHireDate($hireDate)
            ->setHomePhone($homePhone)
            ->setLanguagesSpoken($languagesSpoken)
            ->setLastName($lastName)
            ->setLicense($license)
            ->setMailingAddress1($mailingAddress1)
            ->setMailingAddress2($mailingAddress2)
            ->setNotes($notes)
            ->setOperatorGuid($operatorGuid)
            ->setPosition($position)
            ->setPreferredLanguage($preferredLanguage)
            ->setPreferredPhoneTypeGuid($preferredPhoneTypeGuid)
            ->setProtected($protected)
            ->setStaffGuid($staffGuid)
            ->setStaffID($staffID)
            ->setWorkPhone($workPhone);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Staff
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\Staff
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get CellPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCellPhone()
    {
        return isset($this->CellPhone) ? $this->CellPhone : null;
    }
    /**
     * Set CellPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cellPhone
     * @return \StructType\Staff
     */
    public function setCellPhone($cellPhone = null)
    {
        // validation for constraint: string
        if (!is_null($cellPhone) && !is_string($cellPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cellPhone)), __LINE__);
        }
        if (is_null($cellPhone) || (is_array($cellPhone) && empty($cellPhone))) {
            unset($this->CellPhone);
        } else {
            $this->CellPhone = $cellPhone;
        }
        return $this;
    }
    /**
     * Get Email1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail1()
    {
        return isset($this->Email1) ? $this->Email1 : null;
    }
    /**
     * Set Email1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email1
     * @return \StructType\Staff
     */
    public function setEmail1($email1 = null)
    {
        // validation for constraint: string
        if (!is_null($email1) && !is_string($email1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email1)), __LINE__);
        }
        if (is_null($email1) || (is_array($email1) && empty($email1))) {
            unset($this->Email1);
        } else {
            $this->Email1 = $email1;
        }
        return $this;
    }
    /**
     * Get Email2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail2()
    {
        return isset($this->Email2) ? $this->Email2 : null;
    }
    /**
     * Set Email2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email2
     * @return \StructType\Staff
     */
    public function setEmail2($email2 = null)
    {
        // validation for constraint: string
        if (!is_null($email2) && !is_string($email2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email2)), __LINE__);
        }
        if (is_null($email2) || (is_array($email2) && empty($email2))) {
            unset($this->Email2);
        } else {
            $this->Email2 = $email2;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \StructType\Staff
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\Staff
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get GovernmentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGovernmentID()
    {
        return isset($this->GovernmentID) ? $this->GovernmentID : null;
    }
    /**
     * Set GovernmentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $governmentID
     * @return \StructType\Staff
     */
    public function setGovernmentID($governmentID = null)
    {
        // validation for constraint: string
        if (!is_null($governmentID) && !is_string($governmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($governmentID)), __LINE__);
        }
        if (is_null($governmentID) || (is_array($governmentID) && empty($governmentID))) {
            unset($this->GovernmentID);
        } else {
            $this->GovernmentID = $governmentID;
        }
        return $this;
    }
    /**
     * Get HireDate value
     * @return string|null
     */
    public function getHireDate()
    {
        return $this->HireDate;
    }
    /**
     * Set HireDate value
     * @param string $hireDate
     * @return \StructType\Staff
     */
    public function setHireDate($hireDate = null)
    {
        // validation for constraint: string
        if (!is_null($hireDate) && !is_string($hireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hireDate)), __LINE__);
        }
        $this->HireDate = $hireDate;
        return $this;
    }
    /**
     * Get HomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomePhone()
    {
        return isset($this->HomePhone) ? $this->HomePhone : null;
    }
    /**
     * Set HomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homePhone
     * @return \StructType\Staff
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homePhone)), __LINE__);
        }
        if (is_null($homePhone) || (is_array($homePhone) && empty($homePhone))) {
            unset($this->HomePhone);
        } else {
            $this->HomePhone = $homePhone;
        }
        return $this;
    }
    /**
     * Get LanguagesSpoken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguagesSpoken()
    {
        return isset($this->LanguagesSpoken) ? $this->LanguagesSpoken : null;
    }
    /**
     * Set LanguagesSpoken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $languagesSpoken
     * @return \StructType\Staff
     */
    public function setLanguagesSpoken($languagesSpoken = null)
    {
        // validation for constraint: string
        if (!is_null($languagesSpoken) && !is_string($languagesSpoken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languagesSpoken)), __LINE__);
        }
        if (is_null($languagesSpoken) || (is_array($languagesSpoken) && empty($languagesSpoken))) {
            unset($this->LanguagesSpoken);
        } else {
            $this->LanguagesSpoken = $languagesSpoken;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\Staff
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get License value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLicense()
    {
        return isset($this->License) ? $this->License : null;
    }
    /**
     * Set License value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $license
     * @return \StructType\Staff
     */
    public function setLicense($license = null)
    {
        // validation for constraint: string
        if (!is_null($license) && !is_string($license)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($license)), __LINE__);
        }
        if (is_null($license) || (is_array($license) && empty($license))) {
            unset($this->License);
        } else {
            $this->License = $license;
        }
        return $this;
    }
    /**
     * Get MailingAddress1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailingAddress1()
    {
        return isset($this->MailingAddress1) ? $this->MailingAddress1 : null;
    }
    /**
     * Set MailingAddress1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailingAddress1
     * @return \StructType\Staff
     */
    public function setMailingAddress1($mailingAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($mailingAddress1) && !is_string($mailingAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingAddress1)), __LINE__);
        }
        if (is_null($mailingAddress1) || (is_array($mailingAddress1) && empty($mailingAddress1))) {
            unset($this->MailingAddress1);
        } else {
            $this->MailingAddress1 = $mailingAddress1;
        }
        return $this;
    }
    /**
     * Get MailingAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailingAddress2()
    {
        return isset($this->MailingAddress2) ? $this->MailingAddress2 : null;
    }
    /**
     * Set MailingAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailingAddress2
     * @return \StructType\Staff
     */
    public function setMailingAddress2($mailingAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($mailingAddress2) && !is_string($mailingAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingAddress2)), __LINE__);
        }
        if (is_null($mailingAddress2) || (is_array($mailingAddress2) && empty($mailingAddress2))) {
            unset($this->MailingAddress2);
        } else {
            $this->MailingAddress2 = $mailingAddress2;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \StructType\Staff
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get OperatorGuid value
     * @return string|null
     */
    public function getOperatorGuid()
    {
        return $this->OperatorGuid;
    }
    /**
     * Set OperatorGuid value
     * @param string $operatorGuid
     * @return \StructType\Staff
     */
    public function setOperatorGuid($operatorGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($operatorGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $operatorGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($operatorGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operatorGuid) && !is_string($operatorGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatorGuid)), __LINE__);
        }
        $this->OperatorGuid = $operatorGuid;
        return $this;
    }
    /**
     * Get Position value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPosition()
    {
        return isset($this->Position) ? $this->Position : null;
    }
    /**
     * Set Position value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $position
     * @return \StructType\Staff
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($position)), __LINE__);
        }
        if (is_null($position) || (is_array($position) && empty($position))) {
            unset($this->Position);
        } else {
            $this->Position = $position;
        }
        return $this;
    }
    /**
     * Get PreferredLanguage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredLanguage()
    {
        return isset($this->PreferredLanguage) ? $this->PreferredLanguage : null;
    }
    /**
     * Set PreferredLanguage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredLanguage
     * @return \StructType\Staff
     */
    public function setPreferredLanguage($preferredLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($preferredLanguage) && !is_string($preferredLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferredLanguage)), __LINE__);
        }
        if (is_null($preferredLanguage) || (is_array($preferredLanguage) && empty($preferredLanguage))) {
            unset($this->PreferredLanguage);
        } else {
            $this->PreferredLanguage = $preferredLanguage;
        }
        return $this;
    }
    /**
     * Get PreferredPhoneTypeGuid value
     * @return string|null
     */
    public function getPreferredPhoneTypeGuid()
    {
        return $this->PreferredPhoneTypeGuid;
    }
    /**
     * Set PreferredPhoneTypeGuid value
     * @param string $preferredPhoneTypeGuid
     * @return \StructType\Staff
     */
    public function setPreferredPhoneTypeGuid($preferredPhoneTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($preferredPhoneTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $preferredPhoneTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($preferredPhoneTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($preferredPhoneTypeGuid) && !is_string($preferredPhoneTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferredPhoneTypeGuid)), __LINE__);
        }
        $this->PreferredPhoneTypeGuid = $preferredPhoneTypeGuid;
        return $this;
    }
    /**
     * Get Protected value
     * @return bool|null
     */
    public function getProtected()
    {
        return $this->Protected;
    }
    /**
     * Set Protected value
     * @param bool $protected
     * @return \StructType\Staff
     */
    public function setProtected($protected = null)
    {
        // validation for constraint: boolean
        if (!is_null($protected) && !is_bool($protected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protected)), __LINE__);
        }
        $this->Protected = $protected;
        return $this;
    }
    /**
     * Get StaffGuid value
     * @return string|null
     */
    public function getStaffGuid()
    {
        return $this->StaffGuid;
    }
    /**
     * Set StaffGuid value
     * @param string $staffGuid
     * @return \StructType\Staff
     */
    public function setStaffGuid($staffGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($staffGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $staffGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($staffGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($staffGuid) && !is_string($staffGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($staffGuid)), __LINE__);
        }
        $this->StaffGuid = $staffGuid;
        return $this;
    }
    /**
     * Get StaffID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStaffID()
    {
        return isset($this->StaffID) ? $this->StaffID : null;
    }
    /**
     * Set StaffID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $staffID
     * @return \StructType\Staff
     */
    public function setStaffID($staffID = null)
    {
        // validation for constraint: string
        if (!is_null($staffID) && !is_string($staffID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($staffID)), __LINE__);
        }
        if (is_null($staffID) || (is_array($staffID) && empty($staffID))) {
            unset($this->StaffID);
        } else {
            $this->StaffID = $staffID;
        }
        return $this;
    }
    /**
     * Get WorkPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkPhone()
    {
        return isset($this->WorkPhone) ? $this->WorkPhone : null;
    }
    /**
     * Set WorkPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workPhone
     * @return \StructType\Staff
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workPhone)), __LINE__);
        }
        if (is_null($workPhone) || (is_array($workPhone) && empty($workPhone))) {
            unset($this->WorkPhone);
        } else {
            $this->WorkPhone = $workPhone;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Staff
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
