<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SchoolGrade StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SchoolGrade
 * @subpackage Structs
 */
class SchoolGrade extends AbstractStructBase
{
    /**
     * The Grade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Grade;
    /**
     * The GradeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GradeGuid;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The Regular
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Regular;
    /**
     * The SchoolGradeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchoolGradeGuid;
    /**
     * The SchoolGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchoolGuid;
    /**
     * The SchoolID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchoolID;
    /**
     * The SpecialEd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SpecialEd;
    /**
     * Constructor method for SchoolGrade
     * @uses SchoolGrade::setGrade()
     * @uses SchoolGrade::setGradeGuid()
     * @uses SchoolGrade::setID()
     * @uses SchoolGrade::setRegular()
     * @uses SchoolGrade::setSchoolGradeGuid()
     * @uses SchoolGrade::setSchoolGuid()
     * @uses SchoolGrade::setSchoolID()
     * @uses SchoolGrade::setSpecialEd()
     * @param string $grade
     * @param string $gradeGuid
     * @param \StructType\BPID $iD
     * @param bool $regular
     * @param string $schoolGradeGuid
     * @param string $schoolGuid
     * @param string $schoolID
     * @param bool $specialEd
     */
    public function __construct($grade = null, $gradeGuid = null, \StructType\BPID $iD = null, $regular = null, $schoolGradeGuid = null, $schoolGuid = null, $schoolID = null, $specialEd = null)
    {
        $this
            ->setGrade($grade)
            ->setGradeGuid($gradeGuid)
            ->setID($iD)
            ->setRegular($regular)
            ->setSchoolGradeGuid($schoolGradeGuid)
            ->setSchoolGuid($schoolGuid)
            ->setSchoolID($schoolID)
            ->setSpecialEd($specialEd);
    }
    /**
     * Get Grade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGrade()
    {
        return isset($this->Grade) ? $this->Grade : null;
    }
    /**
     * Set Grade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $grade
     * @return \StructType\SchoolGrade
     */
    public function setGrade($grade = null)
    {
        // validation for constraint: string
        if (!is_null($grade) && !is_string($grade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grade)), __LINE__);
        }
        if (is_null($grade) || (is_array($grade) && empty($grade))) {
            unset($this->Grade);
        } else {
            $this->Grade = $grade;
        }
        return $this;
    }
    /**
     * Get GradeGuid value
     * @return string|null
     */
    public function getGradeGuid()
    {
        return $this->GradeGuid;
    }
    /**
     * Set GradeGuid value
     * @param string $gradeGuid
     * @return \StructType\SchoolGrade
     */
    public function setGradeGuid($gradeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gradeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($gradeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gradeGuid) && !is_string($gradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gradeGuid)), __LINE__);
        }
        $this->GradeGuid = $gradeGuid;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\SchoolGrade
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get Regular value
     * @return bool|null
     */
    public function getRegular()
    {
        return $this->Regular;
    }
    /**
     * Set Regular value
     * @param bool $regular
     * @return \StructType\SchoolGrade
     */
    public function setRegular($regular = null)
    {
        // validation for constraint: boolean
        if (!is_null($regular) && !is_bool($regular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($regular)), __LINE__);
        }
        $this->Regular = $regular;
        return $this;
    }
    /**
     * Get SchoolGradeGuid value
     * @return string|null
     */
    public function getSchoolGradeGuid()
    {
        return $this->SchoolGradeGuid;
    }
    /**
     * Set SchoolGradeGuid value
     * @param string $schoolGradeGuid
     * @return \StructType\SchoolGrade
     */
    public function setSchoolGradeGuid($schoolGradeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($schoolGradeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schoolGradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($schoolGradeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($schoolGradeGuid) && !is_string($schoolGradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolGradeGuid)), __LINE__);
        }
        $this->SchoolGradeGuid = $schoolGradeGuid;
        return $this;
    }
    /**
     * Get SchoolGuid value
     * @return string|null
     */
    public function getSchoolGuid()
    {
        return $this->SchoolGuid;
    }
    /**
     * Set SchoolGuid value
     * @param string $schoolGuid
     * @return \StructType\SchoolGrade
     */
    public function setSchoolGuid($schoolGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($schoolGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schoolGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($schoolGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($schoolGuid) && !is_string($schoolGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolGuid)), __LINE__);
        }
        $this->SchoolGuid = $schoolGuid;
        return $this;
    }
    /**
     * Get SchoolID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchoolID()
    {
        return isset($this->SchoolID) ? $this->SchoolID : null;
    }
    /**
     * Set SchoolID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schoolID
     * @return \StructType\SchoolGrade
     */
    public function setSchoolID($schoolID = null)
    {
        // validation for constraint: string
        if (!is_null($schoolID) && !is_string($schoolID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolID)), __LINE__);
        }
        if (is_null($schoolID) || (is_array($schoolID) && empty($schoolID))) {
            unset($this->SchoolID);
        } else {
            $this->SchoolID = $schoolID;
        }
        return $this;
    }
    /**
     * Get SpecialEd value
     * @return bool|null
     */
    public function getSpecialEd()
    {
        return $this->SpecialEd;
    }
    /**
     * Set SpecialEd value
     * @param bool $specialEd
     * @return \StructType\SchoolGrade
     */
    public function setSpecialEd($specialEd = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialEd) && !is_bool($specialEd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($specialEd)), __LINE__);
        }
        $this->SpecialEd = $specialEd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SchoolGrade
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
