<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SchoolBoundaryGrade StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SchoolBoundaryGrade
 * @subpackage Structs
 */
class SchoolBoundaryGrade extends AbstractStructBase
{
    /**
     * The Grade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Grade;
    /**
     * The GradeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GradeGuid;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The Regular
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Regular;
    /**
     * The SchoolBoundaryGradeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchoolBoundaryGradeGuid;
    /**
     * The SchoolBoundaryGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchoolBoundaryGuid;
    /**
     * The SchoolBoundaryID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchoolBoundaryID;
    /**
     * The SpecialEd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SpecialEd;
    /**
     * Constructor method for SchoolBoundaryGrade
     * @uses SchoolBoundaryGrade::setGrade()
     * @uses SchoolBoundaryGrade::setGradeGuid()
     * @uses SchoolBoundaryGrade::setID()
     * @uses SchoolBoundaryGrade::setRegular()
     * @uses SchoolBoundaryGrade::setSchoolBoundaryGradeGuid()
     * @uses SchoolBoundaryGrade::setSchoolBoundaryGuid()
     * @uses SchoolBoundaryGrade::setSchoolBoundaryID()
     * @uses SchoolBoundaryGrade::setSpecialEd()
     * @param string $grade
     * @param string $gradeGuid
     * @param \StructType\BPID $iD
     * @param bool $regular
     * @param string $schoolBoundaryGradeGuid
     * @param string $schoolBoundaryGuid
     * @param string $schoolBoundaryID
     * @param bool $specialEd
     */
    public function __construct($grade = null, $gradeGuid = null, \StructType\BPID $iD = null, $regular = null, $schoolBoundaryGradeGuid = null, $schoolBoundaryGuid = null, $schoolBoundaryID = null, $specialEd = null)
    {
        $this
            ->setGrade($grade)
            ->setGradeGuid($gradeGuid)
            ->setID($iD)
            ->setRegular($regular)
            ->setSchoolBoundaryGradeGuid($schoolBoundaryGradeGuid)
            ->setSchoolBoundaryGuid($schoolBoundaryGuid)
            ->setSchoolBoundaryID($schoolBoundaryID)
            ->setSpecialEd($specialEd);
    }
    /**
     * Get Grade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGrade()
    {
        return isset($this->Grade) ? $this->Grade : null;
    }
    /**
     * Set Grade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $grade
     * @return \StructType\SchoolBoundaryGrade
     */
    public function setGrade($grade = null)
    {
        // validation for constraint: string
        if (!is_null($grade) && !is_string($grade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grade)), __LINE__);
        }
        if (is_null($grade) || (is_array($grade) && empty($grade))) {
            unset($this->Grade);
        } else {
            $this->Grade = $grade;
        }
        return $this;
    }
    /**
     * Get GradeGuid value
     * @return string|null
     */
    public function getGradeGuid()
    {
        return $this->GradeGuid;
    }
    /**
     * Set GradeGuid value
     * @param string $gradeGuid
     * @return \StructType\SchoolBoundaryGrade
     */
    public function setGradeGuid($gradeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gradeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($gradeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gradeGuid) && !is_string($gradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gradeGuid)), __LINE__);
        }
        $this->GradeGuid = $gradeGuid;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\SchoolBoundaryGrade
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get Regular value
     * @return bool|null
     */
    public function getRegular()
    {
        return $this->Regular;
    }
    /**
     * Set Regular value
     * @param bool $regular
     * @return \StructType\SchoolBoundaryGrade
     */
    public function setRegular($regular = null)
    {
        // validation for constraint: boolean
        if (!is_null($regular) && !is_bool($regular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($regular)), __LINE__);
        }
        $this->Regular = $regular;
        return $this;
    }
    /**
     * Get SchoolBoundaryGradeGuid value
     * @return string|null
     */
    public function getSchoolBoundaryGradeGuid()
    {
        return $this->SchoolBoundaryGradeGuid;
    }
    /**
     * Set SchoolBoundaryGradeGuid value
     * @param string $schoolBoundaryGradeGuid
     * @return \StructType\SchoolBoundaryGrade
     */
    public function setSchoolBoundaryGradeGuid($schoolBoundaryGradeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($schoolBoundaryGradeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schoolBoundaryGradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($schoolBoundaryGradeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($schoolBoundaryGradeGuid) && !is_string($schoolBoundaryGradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolBoundaryGradeGuid)), __LINE__);
        }
        $this->SchoolBoundaryGradeGuid = $schoolBoundaryGradeGuid;
        return $this;
    }
    /**
     * Get SchoolBoundaryGuid value
     * @return string|null
     */
    public function getSchoolBoundaryGuid()
    {
        return $this->SchoolBoundaryGuid;
    }
    /**
     * Set SchoolBoundaryGuid value
     * @param string $schoolBoundaryGuid
     * @return \StructType\SchoolBoundaryGrade
     */
    public function setSchoolBoundaryGuid($schoolBoundaryGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($schoolBoundaryGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schoolBoundaryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($schoolBoundaryGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($schoolBoundaryGuid) && !is_string($schoolBoundaryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolBoundaryGuid)), __LINE__);
        }
        $this->SchoolBoundaryGuid = $schoolBoundaryGuid;
        return $this;
    }
    /**
     * Get SchoolBoundaryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchoolBoundaryID()
    {
        return isset($this->SchoolBoundaryID) ? $this->SchoolBoundaryID : null;
    }
    /**
     * Set SchoolBoundaryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schoolBoundaryID
     * @return \StructType\SchoolBoundaryGrade
     */
    public function setSchoolBoundaryID($schoolBoundaryID = null)
    {
        // validation for constraint: string
        if (!is_null($schoolBoundaryID) && !is_string($schoolBoundaryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolBoundaryID)), __LINE__);
        }
        if (is_null($schoolBoundaryID) || (is_array($schoolBoundaryID) && empty($schoolBoundaryID))) {
            unset($this->SchoolBoundaryID);
        } else {
            $this->SchoolBoundaryID = $schoolBoundaryID;
        }
        return $this;
    }
    /**
     * Get SpecialEd value
     * @return bool|null
     */
    public function getSpecialEd()
    {
        return $this->SpecialEd;
    }
    /**
     * Set SpecialEd value
     * @param bool $specialEd
     * @return \StructType\SchoolBoundaryGrade
     */
    public function setSpecialEd($specialEd = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialEd) && !is_bool($specialEd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($specialEd)), __LINE__);
        }
        $this->SpecialEd = $specialEd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SchoolBoundaryGrade
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
