<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SchoolBoundary StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SchoolBoundary
 * @subpackage Structs
 */
class SchoolBoundary extends AbstractStructBase
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The LatLongs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPosition
     */
    public $LatLongs;
    /**
     * The Protected
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protected;
    /**
     * The Public
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Public;
    /**
     * The Regular
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Regular;
    /**
     * The RetireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RetireDate;
    /**
     * The SIFGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SIFGuid;
    /**
     * The SchoolBoundaryGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchoolBoundaryGuid;
    /**
     * The SchoolBoundaryID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchoolBoundaryID;
    /**
     * The SchoolID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchoolID;
    /**
     * The SpecialEd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SpecialEd;
    /**
     * Constructor method for SchoolBoundary
     * @uses SchoolBoundary::setActive()
     * @uses SchoolBoundary::setDescription()
     * @uses SchoolBoundary::setEffectiveDate()
     * @uses SchoolBoundary::setID()
     * @uses SchoolBoundary::setLatLongs()
     * @uses SchoolBoundary::setProtected()
     * @uses SchoolBoundary::setPublic()
     * @uses SchoolBoundary::setRegular()
     * @uses SchoolBoundary::setRetireDate()
     * @uses SchoolBoundary::setSIFGuid()
     * @uses SchoolBoundary::setSchoolBoundaryGuid()
     * @uses SchoolBoundary::setSchoolBoundaryID()
     * @uses SchoolBoundary::setSchoolID()
     * @uses SchoolBoundary::setSpecialEd()
     * @param bool $active
     * @param string $description
     * @param string $effectiveDate
     * @param \StructType\BPID $iD
     * @param \ArrayType\ArrayOfPosition $latLongs
     * @param bool $protected
     * @param bool $public
     * @param bool $regular
     * @param string $retireDate
     * @param string $sIFGuid
     * @param string $schoolBoundaryGuid
     * @param string $schoolBoundaryID
     * @param string $schoolID
     * @param bool $specialEd
     */
    public function __construct($active = null, $description = null, $effectiveDate = null, \StructType\BPID $iD = null, \ArrayType\ArrayOfPosition $latLongs = null, $protected = null, $public = null, $regular = null, $retireDate = null, $sIFGuid = null, $schoolBoundaryGuid = null, $schoolBoundaryID = null, $schoolID = null, $specialEd = null)
    {
        $this
            ->setActive($active)
            ->setDescription($description)
            ->setEffectiveDate($effectiveDate)
            ->setID($iD)
            ->setLatLongs($latLongs)
            ->setProtected($protected)
            ->setPublic($public)
            ->setRegular($regular)
            ->setRetireDate($retireDate)
            ->setSIFGuid($sIFGuid)
            ->setSchoolBoundaryGuid($schoolBoundaryGuid)
            ->setSchoolBoundaryID($schoolBoundaryID)
            ->setSchoolID($schoolID)
            ->setSpecialEd($specialEd);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\SchoolBoundary
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\SchoolBoundary
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\SchoolBoundary
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\SchoolBoundary
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get LatLongs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPosition|null
     */
    public function getLatLongs()
    {
        return isset($this->LatLongs) ? $this->LatLongs : null;
    }
    /**
     * Set LatLongs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPosition $latLongs
     * @return \StructType\SchoolBoundary
     */
    public function setLatLongs(\ArrayType\ArrayOfPosition $latLongs = null)
    {
        if (is_null($latLongs) || (is_array($latLongs) && empty($latLongs))) {
            unset($this->LatLongs);
        } else {
            $this->LatLongs = $latLongs;
        }
        return $this;
    }
    /**
     * Get Protected value
     * @return bool|null
     */
    public function getProtected()
    {
        return $this->Protected;
    }
    /**
     * Set Protected value
     * @param bool $protected
     * @return \StructType\SchoolBoundary
     */
    public function setProtected($protected = null)
    {
        // validation for constraint: boolean
        if (!is_null($protected) && !is_bool($protected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protected)), __LINE__);
        }
        $this->Protected = $protected;
        return $this;
    }
    /**
     * Get Public value
     * @return bool|null
     */
    public function getPublic()
    {
        return $this->Public;
    }
    /**
     * Set Public value
     * @param bool $public
     * @return \StructType\SchoolBoundary
     */
    public function setPublic($public = null)
    {
        // validation for constraint: boolean
        if (!is_null($public) && !is_bool($public)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($public)), __LINE__);
        }
        $this->Public = $public;
        return $this;
    }
    /**
     * Get Regular value
     * @return bool|null
     */
    public function getRegular()
    {
        return $this->Regular;
    }
    /**
     * Set Regular value
     * @param bool $regular
     * @return \StructType\SchoolBoundary
     */
    public function setRegular($regular = null)
    {
        // validation for constraint: boolean
        if (!is_null($regular) && !is_bool($regular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($regular)), __LINE__);
        }
        $this->Regular = $regular;
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\SchoolBoundary
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get SIFGuid value
     * @return string|null
     */
    public function getSIFGuid()
    {
        return $this->SIFGuid;
    }
    /**
     * Set SIFGuid value
     * @param string $sIFGuid
     * @return \StructType\SchoolBoundary
     */
    public function setSIFGuid($sIFGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sIFGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sIFGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($sIFGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sIFGuid) && !is_string($sIFGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sIFGuid)), __LINE__);
        }
        $this->SIFGuid = $sIFGuid;
        return $this;
    }
    /**
     * Get SchoolBoundaryGuid value
     * @return string|null
     */
    public function getSchoolBoundaryGuid()
    {
        return $this->SchoolBoundaryGuid;
    }
    /**
     * Set SchoolBoundaryGuid value
     * @param string $schoolBoundaryGuid
     * @return \StructType\SchoolBoundary
     */
    public function setSchoolBoundaryGuid($schoolBoundaryGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($schoolBoundaryGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schoolBoundaryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($schoolBoundaryGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($schoolBoundaryGuid) && !is_string($schoolBoundaryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolBoundaryGuid)), __LINE__);
        }
        $this->SchoolBoundaryGuid = $schoolBoundaryGuid;
        return $this;
    }
    /**
     * Get SchoolBoundaryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchoolBoundaryID()
    {
        return isset($this->SchoolBoundaryID) ? $this->SchoolBoundaryID : null;
    }
    /**
     * Set SchoolBoundaryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schoolBoundaryID
     * @return \StructType\SchoolBoundary
     */
    public function setSchoolBoundaryID($schoolBoundaryID = null)
    {
        // validation for constraint: string
        if (!is_null($schoolBoundaryID) && !is_string($schoolBoundaryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolBoundaryID)), __LINE__);
        }
        if (is_null($schoolBoundaryID) || (is_array($schoolBoundaryID) && empty($schoolBoundaryID))) {
            unset($this->SchoolBoundaryID);
        } else {
            $this->SchoolBoundaryID = $schoolBoundaryID;
        }
        return $this;
    }
    /**
     * Get SchoolID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchoolID()
    {
        return isset($this->SchoolID) ? $this->SchoolID : null;
    }
    /**
     * Set SchoolID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schoolID
     * @return \StructType\SchoolBoundary
     */
    public function setSchoolID($schoolID = null)
    {
        // validation for constraint: string
        if (!is_null($schoolID) && !is_string($schoolID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolID)), __LINE__);
        }
        if (is_null($schoolID) || (is_array($schoolID) && empty($schoolID))) {
            unset($this->SchoolID);
        } else {
            $this->SchoolID = $schoolID;
        }
        return $this;
    }
    /**
     * Get SpecialEd value
     * @return bool|null
     */
    public function getSpecialEd()
    {
        return $this->SpecialEd;
    }
    /**
     * Set SpecialEd value
     * @param bool $specialEd
     * @return \StructType\SchoolBoundary
     */
    public function setSpecialEd($specialEd = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialEd) && !is_bool($specialEd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($specialEd)), __LINE__);
        }
        $this->SpecialEd = $specialEd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SchoolBoundary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
