<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveGPSRouteVehicle.Options StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SaveGPSRouteVehicle.Options
 * @subpackage Structs
 */
class SaveGPSRouteVehicle_Options extends WebServiceRequestOptions
{
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The CreateType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateType;
    /**
     * The CreateUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateUser;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ModifyDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ModifyDate;
    /**
     * The ModifyType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModifyType;
    /**
     * The ModifyUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModifyUser;
    /**
     * The ReasonGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReasonGuid;
    /**
     * The RetireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RetireDate;
    /**
     * The RouteGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RouteGuid;
    /**
     * The RouteVehicleGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RouteVehicleGuid;
    /**
     * The VehicleGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VehicleGuid;
    /**
     * Constructor method for SaveGPSRouteVehicle.Options
     * @uses SaveGPSRouteVehicle_Options::setCreateDate()
     * @uses SaveGPSRouteVehicle_Options::setCreateType()
     * @uses SaveGPSRouteVehicle_Options::setCreateUser()
     * @uses SaveGPSRouteVehicle_Options::setEffectiveDate()
     * @uses SaveGPSRouteVehicle_Options::setModifyDate()
     * @uses SaveGPSRouteVehicle_Options::setModifyType()
     * @uses SaveGPSRouteVehicle_Options::setModifyUser()
     * @uses SaveGPSRouteVehicle_Options::setReasonGuid()
     * @uses SaveGPSRouteVehicle_Options::setRetireDate()
     * @uses SaveGPSRouteVehicle_Options::setRouteGuid()
     * @uses SaveGPSRouteVehicle_Options::setRouteVehicleGuid()
     * @uses SaveGPSRouteVehicle_Options::setVehicleGuid()
     * @param string $createDate
     * @param string $createType
     * @param string $createUser
     * @param string $effectiveDate
     * @param string $modifyDate
     * @param string $modifyType
     * @param string $modifyUser
     * @param string $reasonGuid
     * @param string $retireDate
     * @param string $routeGuid
     * @param string $routeVehicleGuid
     * @param string $vehicleGuid
     */
    public function __construct($createDate = null, $createType = null, $createUser = null, $effectiveDate = null, $modifyDate = null, $modifyType = null, $modifyUser = null, $reasonGuid = null, $retireDate = null, $routeGuid = null, $routeVehicleGuid = null, $vehicleGuid = null)
    {
        $this
            ->setCreateDate($createDate)
            ->setCreateType($createType)
            ->setCreateUser($createUser)
            ->setEffectiveDate($effectiveDate)
            ->setModifyDate($modifyDate)
            ->setModifyType($modifyType)
            ->setModifyUser($modifyUser)
            ->setReasonGuid($reasonGuid)
            ->setRetireDate($retireDate)
            ->setRouteGuid($routeGuid)
            ->setRouteVehicleGuid($routeVehicleGuid)
            ->setVehicleGuid($vehicleGuid);
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\SaveGPSRouteVehicle_Options
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateType()
    {
        return isset($this->CreateType) ? $this->CreateType : null;
    }
    /**
     * Set CreateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createType
     * @return \StructType\SaveGPSRouteVehicle_Options
     */
    public function setCreateType($createType = null)
    {
        // validation for constraint: string
        if (!is_null($createType) && !is_string($createType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createType)), __LINE__);
        }
        if (is_null($createType) || (is_array($createType) && empty($createType))) {
            unset($this->CreateType);
        } else {
            $this->CreateType = $createType;
        }
        return $this;
    }
    /**
     * Get CreateUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateUser()
    {
        return isset($this->CreateUser) ? $this->CreateUser : null;
    }
    /**
     * Set CreateUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createUser
     * @return \StructType\SaveGPSRouteVehicle_Options
     */
    public function setCreateUser($createUser = null)
    {
        // validation for constraint: string
        if (!is_null($createUser) && !is_string($createUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createUser)), __LINE__);
        }
        if (is_null($createUser) || (is_array($createUser) && empty($createUser))) {
            unset($this->CreateUser);
        } else {
            $this->CreateUser = $createUser;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\SaveGPSRouteVehicle_Options
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ModifyDate value
     * @return string|null
     */
    public function getModifyDate()
    {
        return $this->ModifyDate;
    }
    /**
     * Set ModifyDate value
     * @param string $modifyDate
     * @return \StructType\SaveGPSRouteVehicle_Options
     */
    public function setModifyDate($modifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifyDate) && !is_string($modifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifyDate)), __LINE__);
        }
        $this->ModifyDate = $modifyDate;
        return $this;
    }
    /**
     * Get ModifyType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModifyType()
    {
        return isset($this->ModifyType) ? $this->ModifyType : null;
    }
    /**
     * Set ModifyType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modifyType
     * @return \StructType\SaveGPSRouteVehicle_Options
     */
    public function setModifyType($modifyType = null)
    {
        // validation for constraint: string
        if (!is_null($modifyType) && !is_string($modifyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifyType)), __LINE__);
        }
        if (is_null($modifyType) || (is_array($modifyType) && empty($modifyType))) {
            unset($this->ModifyType);
        } else {
            $this->ModifyType = $modifyType;
        }
        return $this;
    }
    /**
     * Get ModifyUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModifyUser()
    {
        return isset($this->ModifyUser) ? $this->ModifyUser : null;
    }
    /**
     * Set ModifyUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modifyUser
     * @return \StructType\SaveGPSRouteVehicle_Options
     */
    public function setModifyUser($modifyUser = null)
    {
        // validation for constraint: string
        if (!is_null($modifyUser) && !is_string($modifyUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifyUser)), __LINE__);
        }
        if (is_null($modifyUser) || (is_array($modifyUser) && empty($modifyUser))) {
            unset($this->ModifyUser);
        } else {
            $this->ModifyUser = $modifyUser;
        }
        return $this;
    }
    /**
     * Get ReasonGuid value
     * @return string|null
     */
    public function getReasonGuid()
    {
        return $this->ReasonGuid;
    }
    /**
     * Set ReasonGuid value
     * @param string $reasonGuid
     * @return \StructType\SaveGPSRouteVehicle_Options
     */
    public function setReasonGuid($reasonGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($reasonGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reasonGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($reasonGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reasonGuid) && !is_string($reasonGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reasonGuid)), __LINE__);
        }
        $this->ReasonGuid = $reasonGuid;
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\SaveGPSRouteVehicle_Options
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get RouteGuid value
     * @return string|null
     */
    public function getRouteGuid()
    {
        return $this->RouteGuid;
    }
    /**
     * Set RouteGuid value
     * @param string $routeGuid
     * @return \StructType\SaveGPSRouteVehicle_Options
     */
    public function setRouteGuid($routeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($routeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $routeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($routeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routeGuid) && !is_string($routeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeGuid)), __LINE__);
        }
        $this->RouteGuid = $routeGuid;
        return $this;
    }
    /**
     * Get RouteVehicleGuid value
     * @return string|null
     */
    public function getRouteVehicleGuid()
    {
        return $this->RouteVehicleGuid;
    }
    /**
     * Set RouteVehicleGuid value
     * @param string $routeVehicleGuid
     * @return \StructType\SaveGPSRouteVehicle_Options
     */
    public function setRouteVehicleGuid($routeVehicleGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($routeVehicleGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $routeVehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($routeVehicleGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routeVehicleGuid) && !is_string($routeVehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeVehicleGuid)), __LINE__);
        }
        $this->RouteVehicleGuid = $routeVehicleGuid;
        return $this;
    }
    /**
     * Get VehicleGuid value
     * @return string|null
     */
    public function getVehicleGuid()
    {
        return $this->VehicleGuid;
    }
    /**
     * Set VehicleGuid value
     * @param string $vehicleGuid
     * @return \StructType\SaveGPSRouteVehicle_Options
     */
    public function setVehicleGuid($vehicleGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($vehicleGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $vehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($vehicleGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vehicleGuid) && !is_string($vehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleGuid)), __LINE__);
        }
        $this->VehicleGuid = $vehicleGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaveGPSRouteVehicle_Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
