<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RunPoint StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RunPoint
 * @subpackage Structs
 */
class RunPoint extends AbstractStructBase
{
    /**
     * The BusStopID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BusStopID;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Position
     */
    public $Position;
    /**
     * Constructor method for RunPoint
     * @uses RunPoint::setBusStopID()
     * @uses RunPoint::setPosition()
     * @param string $busStopID
     * @param \StructType\Position $position
     */
    public function __construct($busStopID = null, \StructType\Position $position = null)
    {
        $this
            ->setBusStopID($busStopID)
            ->setPosition($position);
    }
    /**
     * Get BusStopID value
     * @return string|null
     */
    public function getBusStopID()
    {
        return $this->BusStopID;
    }
    /**
     * Set BusStopID value
     * @param string $busStopID
     * @return \StructType\RunPoint
     */
    public function setBusStopID($busStopID = null)
    {
        // validation for constraint: string
        if (!is_null($busStopID) && !is_string($busStopID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($busStopID)), __LINE__);
        }
        $this->BusStopID = $busStopID;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\RunPoint
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RunPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
