<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Run StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Run
 * @subpackage Structs
 */
class Run extends AbstractStructBase
{
    /**
     * The ComponentID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ComponentID;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The EndTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EndTime;
    /**
     * The Instruction
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Instruction;
    /**
     * The ModifiedDate
     * @var string
     */
    public $ModifiedDate;
    /**
     * The RouteID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RouteID;
    /**
     * The RunID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RunID;
    /**
     * The RunOrder
     * @var int
     */
    public $RunOrder;
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StartTime;
    /**
     * The ComponentVariation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComponentVariation;
    /**
     * The RunVariation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RunVariation;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Distance;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The LatLongs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPosition
     */
    public $LatLongs;
    /**
     * The Protected
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protected;
    /**
     * The Regular
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Regular;
    /**
     * The RetireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RetireDate;
    /**
     * The RunGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RunGuid;
    /**
     * The RunVGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RunVGuid;
    /**
     * The SIFGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SIFGuid;
    /**
     * The SpecialEd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SpecialEd;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Type;
    /**
     * The RunPoints
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRunPoint
     */
    public $RunPoints;
    /**
     * Constructor method for Run
     * @uses Run::setComponentID()
     * @uses Run::setCreatedDate()
     * @uses Run::setDescription()
     * @uses Run::setEndTime()
     * @uses Run::setInstruction()
     * @uses Run::setModifiedDate()
     * @uses Run::setRouteID()
     * @uses Run::setRunID()
     * @uses Run::setRunOrder()
     * @uses Run::setStartTime()
     * @uses Run::setComponentVariation()
     * @uses Run::setRunVariation()
     * @uses Run::setActive()
     * @uses Run::setDistance()
     * @uses Run::setEffectiveDate()
     * @uses Run::setID()
     * @uses Run::setLatLongs()
     * @uses Run::setProtected()
     * @uses Run::setRegular()
     * @uses Run::setRetireDate()
     * @uses Run::setRunGuid()
     * @uses Run::setRunVGuid()
     * @uses Run::setSIFGuid()
     * @uses Run::setSpecialEd()
     * @uses Run::setType()
     * @uses Run::setRunPoints()
     * @param string $componentID
     * @param string $createdDate
     * @param string $description
     * @param string $endTime
     * @param string $instruction
     * @param string $modifiedDate
     * @param string $routeID
     * @param string $runID
     * @param int $runOrder
     * @param string $startTime
     * @param string $componentVariation
     * @param string $runVariation
     * @param bool $active
     * @param float $distance
     * @param string $effectiveDate
     * @param \StructType\BPID $iD
     * @param \ArrayType\ArrayOfPosition $latLongs
     * @param bool $protected
     * @param bool $regular
     * @param string $retireDate
     * @param string $runGuid
     * @param string $runVGuid
     * @param string $sIFGuid
     * @param bool $specialEd
     * @param int $type
     * @param \ArrayType\ArrayOfRunPoint $runPoints
     */
    public function __construct($componentID = null, $createdDate = null, $description = null, $endTime = null, $instruction = null, $modifiedDate = null, $routeID = null, $runID = null, $runOrder = null, $startTime = null, $componentVariation = null, $runVariation = null, $active = null, $distance = null, $effectiveDate = null, \StructType\BPID $iD = null, \ArrayType\ArrayOfPosition $latLongs = null, $protected = null, $regular = null, $retireDate = null, $runGuid = null, $runVGuid = null, $sIFGuid = null, $specialEd = null, $type = null, \ArrayType\ArrayOfRunPoint $runPoints = null)
    {
        $this
            ->setComponentID($componentID)
            ->setCreatedDate($createdDate)
            ->setDescription($description)
            ->setEndTime($endTime)
            ->setInstruction($instruction)
            ->setModifiedDate($modifiedDate)
            ->setRouteID($routeID)
            ->setRunID($runID)
            ->setRunOrder($runOrder)
            ->setStartTime($startTime)
            ->setComponentVariation($componentVariation)
            ->setRunVariation($runVariation)
            ->setActive($active)
            ->setDistance($distance)
            ->setEffectiveDate($effectiveDate)
            ->setID($iD)
            ->setLatLongs($latLongs)
            ->setProtected($protected)
            ->setRegular($regular)
            ->setRetireDate($retireDate)
            ->setRunGuid($runGuid)
            ->setRunVGuid($runVGuid)
            ->setSIFGuid($sIFGuid)
            ->setSpecialEd($specialEd)
            ->setType($type)
            ->setRunPoints($runPoints);
    }
    /**
     * Get ComponentID value
     * @return string|null
     */
    public function getComponentID()
    {
        return $this->ComponentID;
    }
    /**
     * Set ComponentID value
     * @param string $componentID
     * @return \StructType\Run
     */
    public function setComponentID($componentID = null)
    {
        // validation for constraint: string
        if (!is_null($componentID) && !is_string($componentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($componentID)), __LINE__);
        }
        $this->ComponentID = $componentID;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\Run
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Run
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \StructType\Run
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Get Instruction value
     * @return string|null
     */
    public function getInstruction()
    {
        return $this->Instruction;
    }
    /**
     * Set Instruction value
     * @param string $instruction
     * @return \StructType\Run
     */
    public function setInstruction($instruction = null)
    {
        // validation for constraint: string
        if (!is_null($instruction) && !is_string($instruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instruction)), __LINE__);
        }
        $this->Instruction = $instruction;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * @return string|null
     */
    public function getModifiedDate()
    {
        return $this->ModifiedDate;
    }
    /**
     * Set ModifiedDate value
     * @param string $modifiedDate
     * @return \StructType\Run
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedDate)), __LINE__);
        }
        $this->ModifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get RouteID value
     * @return string|null
     */
    public function getRouteID()
    {
        return $this->RouteID;
    }
    /**
     * Set RouteID value
     * @param string $routeID
     * @return \StructType\Run
     */
    public function setRouteID($routeID = null)
    {
        // validation for constraint: string
        if (!is_null($routeID) && !is_string($routeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeID)), __LINE__);
        }
        $this->RouteID = $routeID;
        return $this;
    }
    /**
     * Get RunID value
     * @return string|null
     */
    public function getRunID()
    {
        return $this->RunID;
    }
    /**
     * Set RunID value
     * @param string $runID
     * @return \StructType\Run
     */
    public function setRunID($runID = null)
    {
        // validation for constraint: string
        if (!is_null($runID) && !is_string($runID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runID)), __LINE__);
        }
        $this->RunID = $runID;
        return $this;
    }
    /**
     * Get RunOrder value
     * @return int|null
     */
    public function getRunOrder()
    {
        return $this->RunOrder;
    }
    /**
     * Set RunOrder value
     * @param int $runOrder
     * @return \StructType\Run
     */
    public function setRunOrder($runOrder = null)
    {
        // validation for constraint: int
        if (!is_null($runOrder) && !is_numeric($runOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($runOrder)), __LINE__);
        }
        $this->RunOrder = $runOrder;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\Run
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get ComponentVariation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComponentVariation()
    {
        return isset($this->ComponentVariation) ? $this->ComponentVariation : null;
    }
    /**
     * Set ComponentVariation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $componentVariation
     * @return \StructType\Run
     */
    public function setComponentVariation($componentVariation = null)
    {
        // validation for constraint: string
        if (!is_null($componentVariation) && !is_string($componentVariation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($componentVariation)), __LINE__);
        }
        if (is_null($componentVariation) || (is_array($componentVariation) && empty($componentVariation))) {
            unset($this->ComponentVariation);
        } else {
            $this->ComponentVariation = $componentVariation;
        }
        return $this;
    }
    /**
     * Get RunVariation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRunVariation()
    {
        return isset($this->RunVariation) ? $this->RunVariation : null;
    }
    /**
     * Set RunVariation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $runVariation
     * @return \StructType\Run
     */
    public function setRunVariation($runVariation = null)
    {
        // validation for constraint: string
        if (!is_null($runVariation) && !is_string($runVariation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runVariation)), __LINE__);
        }
        if (is_null($runVariation) || (is_array($runVariation) && empty($runVariation))) {
            unset($this->RunVariation);
        } else {
            $this->RunVariation = $runVariation;
        }
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Run
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Distance value
     * @return float|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param float $distance
     * @return \StructType\Run
     */
    public function setDistance($distance = null)
    {
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Run
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\Run
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get LatLongs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPosition|null
     */
    public function getLatLongs()
    {
        return isset($this->LatLongs) ? $this->LatLongs : null;
    }
    /**
     * Set LatLongs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPosition $latLongs
     * @return \StructType\Run
     */
    public function setLatLongs(\ArrayType\ArrayOfPosition $latLongs = null)
    {
        if (is_null($latLongs) || (is_array($latLongs) && empty($latLongs))) {
            unset($this->LatLongs);
        } else {
            $this->LatLongs = $latLongs;
        }
        return $this;
    }
    /**
     * Get Protected value
     * @return bool|null
     */
    public function getProtected()
    {
        return $this->Protected;
    }
    /**
     * Set Protected value
     * @param bool $protected
     * @return \StructType\Run
     */
    public function setProtected($protected = null)
    {
        // validation for constraint: boolean
        if (!is_null($protected) && !is_bool($protected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protected)), __LINE__);
        }
        $this->Protected = $protected;
        return $this;
    }
    /**
     * Get Regular value
     * @return bool|null
     */
    public function getRegular()
    {
        return $this->Regular;
    }
    /**
     * Set Regular value
     * @param bool $regular
     * @return \StructType\Run
     */
    public function setRegular($regular = null)
    {
        // validation for constraint: boolean
        if (!is_null($regular) && !is_bool($regular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($regular)), __LINE__);
        }
        $this->Regular = $regular;
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\Run
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get RunGuid value
     * @return string|null
     */
    public function getRunGuid()
    {
        return $this->RunGuid;
    }
    /**
     * Set RunGuid value
     * @param string $runGuid
     * @return \StructType\Run
     */
    public function setRunGuid($runGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($runGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $runGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($runGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($runGuid) && !is_string($runGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runGuid)), __LINE__);
        }
        $this->RunGuid = $runGuid;
        return $this;
    }
    /**
     * Get RunVGuid value
     * @return string|null
     */
    public function getRunVGuid()
    {
        return $this->RunVGuid;
    }
    /**
     * Set RunVGuid value
     * @param string $runVGuid
     * @return \StructType\Run
     */
    public function setRunVGuid($runVGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($runVGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $runVGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($runVGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($runVGuid) && !is_string($runVGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runVGuid)), __LINE__);
        }
        $this->RunVGuid = $runVGuid;
        return $this;
    }
    /**
     * Get SIFGuid value
     * @return string|null
     */
    public function getSIFGuid()
    {
        return $this->SIFGuid;
    }
    /**
     * Set SIFGuid value
     * @param string $sIFGuid
     * @return \StructType\Run
     */
    public function setSIFGuid($sIFGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sIFGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sIFGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($sIFGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sIFGuid) && !is_string($sIFGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sIFGuid)), __LINE__);
        }
        $this->SIFGuid = $sIFGuid;
        return $this;
    }
    /**
     * Get SpecialEd value
     * @return bool|null
     */
    public function getSpecialEd()
    {
        return $this->SpecialEd;
    }
    /**
     * Set SpecialEd value
     * @param bool $specialEd
     * @return \StructType\Run
     */
    public function setSpecialEd($specialEd = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialEd) && !is_bool($specialEd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($specialEd)), __LINE__);
        }
        $this->SpecialEd = $specialEd;
        return $this;
    }
    /**
     * Get Type value
     * @return int|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\Run
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !is_numeric($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get RunPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRunPoint|null
     */
    public function getRunPoints()
    {
        return isset($this->RunPoints) ? $this->RunPoints : null;
    }
    /**
     * Set RunPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRunPoint $runPoints
     * @return \StructType\Run
     */
    public function setRunPoints(\ArrayType\ArrayOfRunPoint $runPoints = null)
    {
        if (is_null($runPoints) || (is_array($runPoints) && empty($runPoints))) {
            unset($this->RunPoints);
        } else {
            $this->RunPoints = $runPoints;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Run
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
