<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Program StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Program
 * @subpackage Structs
 */
class Program extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SpecialEd
     * @var bool
     */
    public $SpecialEd;
    /**
     * Constructor method for Program
     * @uses Program::setName()
     * @uses Program::setSpecialEd()
     * @param string $name
     * @param bool $specialEd
     */
    public function __construct($name = null, $specialEd = null)
    {
        $this
            ->setName($name)
            ->setSpecialEd($specialEd);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Program
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get SpecialEd value
     * @return bool|null
     */
    public function getSpecialEd()
    {
        return $this->SpecialEd;
    }
    /**
     * Set SpecialEd value
     * @param bool $specialEd
     * @return \StructType\Program
     */
    public function setSpecialEd($specialEd = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialEd) && !is_bool($specialEd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($specialEd)), __LINE__);
        }
        $this->SpecialEd = $specialEd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Program
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
