<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Operator StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Operator
 * @subpackage Structs
 */
class Operator extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The MailingAddress1
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MailingAddress1;
    /**
     * The MailingAddress2
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MailingAddress2;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OperatorID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OperatorID;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * Constructor method for Operator
     * @uses Operator::setDisplayName()
     * @uses Operator::setEmail()
     * @uses Operator::setMailingAddress1()
     * @uses Operator::setMailingAddress2()
     * @uses Operator::setName()
     * @uses Operator::setOperatorID()
     * @uses Operator::setPhone()
     * @param string $displayName
     * @param string $email
     * @param string $mailingAddress1
     * @param string $mailingAddress2
     * @param string $name
     * @param string $operatorID
     * @param string $phone
     */
    public function __construct($displayName = null, $email = null, $mailingAddress1 = null, $mailingAddress2 = null, $name = null, $operatorID = null, $phone = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setEmail($email)
            ->setMailingAddress1($mailingAddress1)
            ->setMailingAddress2($mailingAddress2)
            ->setName($name)
            ->setOperatorID($operatorID)
            ->setPhone($phone);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\Operator
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Operator
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get MailingAddress1 value
     * @return string|null
     */
    public function getMailingAddress1()
    {
        return $this->MailingAddress1;
    }
    /**
     * Set MailingAddress1 value
     * @param string $mailingAddress1
     * @return \StructType\Operator
     */
    public function setMailingAddress1($mailingAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($mailingAddress1) && !is_string($mailingAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingAddress1)), __LINE__);
        }
        $this->MailingAddress1 = $mailingAddress1;
        return $this;
    }
    /**
     * Get MailingAddress2 value
     * @return string|null
     */
    public function getMailingAddress2()
    {
        return $this->MailingAddress2;
    }
    /**
     * Set MailingAddress2 value
     * @param string $mailingAddress2
     * @return \StructType\Operator
     */
    public function setMailingAddress2($mailingAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($mailingAddress2) && !is_string($mailingAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingAddress2)), __LINE__);
        }
        $this->MailingAddress2 = $mailingAddress2;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Operator
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get OperatorID value
     * @return string|null
     */
    public function getOperatorID()
    {
        return $this->OperatorID;
    }
    /**
     * Set OperatorID value
     * @param string $operatorID
     * @return \StructType\Operator
     */
    public function setOperatorID($operatorID = null)
    {
        // validation for constraint: string
        if (!is_null($operatorID) && !is_string($operatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatorID)), __LINE__);
        }
        $this->OperatorID = $operatorID;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\Operator
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Operator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
