<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GradeSchoolType StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GradeSchoolType
 * @subpackage Structs
 */
class GradeSchoolType extends AbstractStructBase
{
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The CreateType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateType;
    /**
     * The CreateUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateUser;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The GradeSchoolTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GradeSchoolTypeGuid;
    /**
     * The ModifyDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ModifyDate;
    /**
     * The ModifyType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModifyType;
    /**
     * The ModifyUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModifyUser;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SortOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SortOrder;
    /**
     * Constructor method for GradeSchoolType
     * @uses GradeSchoolType::setCreateDate()
     * @uses GradeSchoolType::setCreateType()
     * @uses GradeSchoolType::setCreateUser()
     * @uses GradeSchoolType::setDescription()
     * @uses GradeSchoolType::setGradeSchoolTypeGuid()
     * @uses GradeSchoolType::setModifyDate()
     * @uses GradeSchoolType::setModifyType()
     * @uses GradeSchoolType::setModifyUser()
     * @uses GradeSchoolType::setName()
     * @uses GradeSchoolType::setSortOrder()
     * @param string $createDate
     * @param string $createType
     * @param string $createUser
     * @param string $description
     * @param string $gradeSchoolTypeGuid
     * @param string $modifyDate
     * @param string $modifyType
     * @param string $modifyUser
     * @param string $name
     * @param int $sortOrder
     */
    public function __construct($createDate = null, $createType = null, $createUser = null, $description = null, $gradeSchoolTypeGuid = null, $modifyDate = null, $modifyType = null, $modifyUser = null, $name = null, $sortOrder = null)
    {
        $this
            ->setCreateDate($createDate)
            ->setCreateType($createType)
            ->setCreateUser($createUser)
            ->setDescription($description)
            ->setGradeSchoolTypeGuid($gradeSchoolTypeGuid)
            ->setModifyDate($modifyDate)
            ->setModifyType($modifyType)
            ->setModifyUser($modifyUser)
            ->setName($name)
            ->setSortOrder($sortOrder);
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\GradeSchoolType
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateType()
    {
        return isset($this->CreateType) ? $this->CreateType : null;
    }
    /**
     * Set CreateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createType
     * @return \StructType\GradeSchoolType
     */
    public function setCreateType($createType = null)
    {
        // validation for constraint: string
        if (!is_null($createType) && !is_string($createType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createType)), __LINE__);
        }
        if (is_null($createType) || (is_array($createType) && empty($createType))) {
            unset($this->CreateType);
        } else {
            $this->CreateType = $createType;
        }
        return $this;
    }
    /**
     * Get CreateUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateUser()
    {
        return isset($this->CreateUser) ? $this->CreateUser : null;
    }
    /**
     * Set CreateUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createUser
     * @return \StructType\GradeSchoolType
     */
    public function setCreateUser($createUser = null)
    {
        // validation for constraint: string
        if (!is_null($createUser) && !is_string($createUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createUser)), __LINE__);
        }
        if (is_null($createUser) || (is_array($createUser) && empty($createUser))) {
            unset($this->CreateUser);
        } else {
            $this->CreateUser = $createUser;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\GradeSchoolType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get GradeSchoolTypeGuid value
     * @return string|null
     */
    public function getGradeSchoolTypeGuid()
    {
        return $this->GradeSchoolTypeGuid;
    }
    /**
     * Set GradeSchoolTypeGuid value
     * @param string $gradeSchoolTypeGuid
     * @return \StructType\GradeSchoolType
     */
    public function setGradeSchoolTypeGuid($gradeSchoolTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gradeSchoolTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gradeSchoolTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($gradeSchoolTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gradeSchoolTypeGuid) && !is_string($gradeSchoolTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gradeSchoolTypeGuid)), __LINE__);
        }
        $this->GradeSchoolTypeGuid = $gradeSchoolTypeGuid;
        return $this;
    }
    /**
     * Get ModifyDate value
     * @return string|null
     */
    public function getModifyDate()
    {
        return $this->ModifyDate;
    }
    /**
     * Set ModifyDate value
     * @param string $modifyDate
     * @return \StructType\GradeSchoolType
     */
    public function setModifyDate($modifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifyDate) && !is_string($modifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifyDate)), __LINE__);
        }
        $this->ModifyDate = $modifyDate;
        return $this;
    }
    /**
     * Get ModifyType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModifyType()
    {
        return isset($this->ModifyType) ? $this->ModifyType : null;
    }
    /**
     * Set ModifyType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modifyType
     * @return \StructType\GradeSchoolType
     */
    public function setModifyType($modifyType = null)
    {
        // validation for constraint: string
        if (!is_null($modifyType) && !is_string($modifyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifyType)), __LINE__);
        }
        if (is_null($modifyType) || (is_array($modifyType) && empty($modifyType))) {
            unset($this->ModifyType);
        } else {
            $this->ModifyType = $modifyType;
        }
        return $this;
    }
    /**
     * Get ModifyUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModifyUser()
    {
        return isset($this->ModifyUser) ? $this->ModifyUser : null;
    }
    /**
     * Set ModifyUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modifyUser
     * @return \StructType\GradeSchoolType
     */
    public function setModifyUser($modifyUser = null)
    {
        // validation for constraint: string
        if (!is_null($modifyUser) && !is_string($modifyUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifyUser)), __LINE__);
        }
        if (is_null($modifyUser) || (is_array($modifyUser) && empty($modifyUser))) {
            unset($this->ModifyUser);
        } else {
            $this->ModifyUser = $modifyUser;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\GradeSchoolType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param int $sortOrder
     * @return \StructType\GradeSchoolType
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !is_numeric($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GradeSchoolType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
