<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDatabaseGuidResponse StructType
 * @subpackage Structs
 */
class GetDatabaseGuidResponse extends AbstractStructBase
{
    /**
     * The GetDatabaseGuidResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GetDatabaseGuidResult;
    /**
     * Constructor method for GetDatabaseGuidResponse
     * @uses GetDatabaseGuidResponse::setGetDatabaseGuidResult()
     * @param string $getDatabaseGuidResult
     */
    public function __construct($getDatabaseGuidResult = null)
    {
        $this
            ->setGetDatabaseGuidResult($getDatabaseGuidResult);
    }
    /**
     * Get GetDatabaseGuidResult value
     * @return string|null
     */
    public function getGetDatabaseGuidResult()
    {
        return $this->GetDatabaseGuidResult;
    }
    /**
     * Set GetDatabaseGuidResult value
     * @param string $getDatabaseGuidResult
     * @return \StructType\GetDatabaseGuidResponse
     */
    public function setGetDatabaseGuidResult($getDatabaseGuidResult = null)
    {
        // validation for constraint: pattern
        if (is_scalar($getDatabaseGuidResult) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $getDatabaseGuidResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($getDatabaseGuidResult, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($getDatabaseGuidResult) && !is_string($getDatabaseGuidResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($getDatabaseGuidResult)), __LINE__);
        }
        $this->GetDatabaseGuidResult = $getDatabaseGuidResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDatabaseGuidResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
