<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllZonesByType StructType
 * @subpackage Structs
 */
class GetAllZonesByType extends AbstractStructBase
{
    /**
     * The databaseGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $databaseGuid;
    /**
     * The zoneTypeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $zoneTypeName;
    /**
     * Constructor method for GetAllZonesByType
     * @uses GetAllZonesByType::setDatabaseGuid()
     * @uses GetAllZonesByType::setZoneTypeName()
     * @param string $databaseGuid
     * @param string $zoneTypeName
     */
    public function __construct($databaseGuid = null, $zoneTypeName = null)
    {
        $this
            ->setDatabaseGuid($databaseGuid)
            ->setZoneTypeName($zoneTypeName);
    }
    /**
     * Get databaseGuid value
     * @return string|null
     */
    public function getDatabaseGuid()
    {
        return $this->databaseGuid;
    }
    /**
     * Set databaseGuid value
     * @param string $databaseGuid
     * @return \StructType\GetAllZonesByType
     */
    public function setDatabaseGuid($databaseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($databaseGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($databaseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($databaseGuid) && !is_string($databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseGuid)), __LINE__);
        }
        $this->databaseGuid = $databaseGuid;
        return $this;
    }
    /**
     * Get zoneTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZoneTypeName()
    {
        return isset($this->zoneTypeName) ? $this->zoneTypeName : null;
    }
    /**
     * Set zoneTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zoneTypeName
     * @return \StructType\GetAllZonesByType
     */
    public function setZoneTypeName($zoneTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($zoneTypeName) && !is_string($zoneTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zoneTypeName)), __LINE__);
        }
        if (is_null($zoneTypeName) || (is_array($zoneTypeName) && empty($zoneTypeName))) {
            unset($this->zoneTypeName);
        } else {
            $this->zoneTypeName = $zoneTypeName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllZonesByType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
