<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllStudentTransChangesXML StructType
 * @subpackage Structs
 */
class GetAllStudentTransChangesXML extends AbstractStructBase
{
    /**
     * The databaseGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $databaseGuid;
    /**
     * The fromDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fromDate;
    /**
     * The toDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $toDate;
    /**
     * The includeVehicleAndDriverChanges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeVehicleAndDriverChanges;
    /**
     * Constructor method for GetAllStudentTransChangesXML
     * @uses GetAllStudentTransChangesXML::setDatabaseGuid()
     * @uses GetAllStudentTransChangesXML::setFromDate()
     * @uses GetAllStudentTransChangesXML::setToDate()
     * @uses GetAllStudentTransChangesXML::setIncludeVehicleAndDriverChanges()
     * @param string $databaseGuid
     * @param string $fromDate
     * @param string $toDate
     * @param bool $includeVehicleAndDriverChanges
     */
    public function __construct($databaseGuid = null, $fromDate = null, $toDate = null, $includeVehicleAndDriverChanges = null)
    {
        $this
            ->setDatabaseGuid($databaseGuid)
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setIncludeVehicleAndDriverChanges($includeVehicleAndDriverChanges);
    }
    /**
     * Get databaseGuid value
     * @return string|null
     */
    public function getDatabaseGuid()
    {
        return $this->databaseGuid;
    }
    /**
     * Set databaseGuid value
     * @param string $databaseGuid
     * @return \StructType\GetAllStudentTransChangesXML
     */
    public function setDatabaseGuid($databaseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($databaseGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($databaseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($databaseGuid) && !is_string($databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseGuid)), __LINE__);
        }
        $this->databaseGuid = $databaseGuid;
        return $this;
    }
    /**
     * Get fromDate value
     * @return string|null
     */
    public function getFromDate()
    {
        return $this->fromDate;
    }
    /**
     * Set fromDate value
     * @param string $fromDate
     * @return \StructType\GetAllStudentTransChangesXML
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDate)), __LINE__);
        }
        $this->fromDate = $fromDate;
        return $this;
    }
    /**
     * Get toDate value
     * @return string|null
     */
    public function getToDate()
    {
        return $this->toDate;
    }
    /**
     * Set toDate value
     * @param string $toDate
     * @return \StructType\GetAllStudentTransChangesXML
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toDate)), __LINE__);
        }
        $this->toDate = $toDate;
        return $this;
    }
    /**
     * Get includeVehicleAndDriverChanges value
     * @return bool|null
     */
    public function getIncludeVehicleAndDriverChanges()
    {
        return $this->includeVehicleAndDriverChanges;
    }
    /**
     * Set includeVehicleAndDriverChanges value
     * @param bool $includeVehicleAndDriverChanges
     * @return \StructType\GetAllStudentTransChangesXML
     */
    public function setIncludeVehicleAndDriverChanges($includeVehicleAndDriverChanges = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeVehicleAndDriverChanges) && !is_bool($includeVehicleAndDriverChanges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeVehicleAndDriverChanges)), __LINE__);
        }
        $this->includeVehicleAndDriverChanges = $includeVehicleAndDriverChanges;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllStudentTransChangesXML
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
