<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllLocations.Options StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAllLocations.Options
 * @subpackage Structs
 */
class GetAllLocations_Options extends WebServiceRequestOptions
{
    /**
     * The IncludeSpatialData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeSpatialData;
    /**
     * The LastLocationID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastLocationID;
    /**
     * The PackageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PackageSize;
    /**
     * Constructor method for GetAllLocations.Options
     * @uses GetAllLocations_Options::setIncludeSpatialData()
     * @uses GetAllLocations_Options::setLastLocationID()
     * @uses GetAllLocations_Options::setPackageSize()
     * @param bool $includeSpatialData
     * @param string $lastLocationID
     * @param int $packageSize
     */
    public function __construct($includeSpatialData = null, $lastLocationID = null, $packageSize = null)
    {
        $this
            ->setIncludeSpatialData($includeSpatialData)
            ->setLastLocationID($lastLocationID)
            ->setPackageSize($packageSize);
    }
    /**
     * Get IncludeSpatialData value
     * @return bool|null
     */
    public function getIncludeSpatialData()
    {
        return $this->IncludeSpatialData;
    }
    /**
     * Set IncludeSpatialData value
     * @param bool $includeSpatialData
     * @return \StructType\GetAllLocations_Options
     */
    public function setIncludeSpatialData($includeSpatialData = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSpatialData) && !is_bool($includeSpatialData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeSpatialData)), __LINE__);
        }
        $this->IncludeSpatialData = $includeSpatialData;
        return $this;
    }
    /**
     * Get LastLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastLocationID()
    {
        return isset($this->LastLocationID) ? $this->LastLocationID : null;
    }
    /**
     * Set LastLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastLocationID
     * @return \StructType\GetAllLocations_Options
     */
    public function setLastLocationID($lastLocationID = null)
    {
        // validation for constraint: string
        if (!is_null($lastLocationID) && !is_string($lastLocationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastLocationID)), __LINE__);
        }
        if (is_null($lastLocationID) || (is_array($lastLocationID) && empty($lastLocationID))) {
            unset($this->LastLocationID);
        } else {
            $this->LastLocationID = $lastLocationID;
        }
        return $this;
    }
    /**
     * Get PackageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPackageSize()
    {
        return isset($this->PackageSize) ? $this->PackageSize : null;
    }
    /**
     * Set PackageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $packageSize
     * @return \StructType\GetAllLocations_Options
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !is_numeric($packageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageSize)), __LINE__);
        }
        if (is_null($packageSize) || (is_array($packageSize) && empty($packageSize))) {
            unset($this->PackageSize);
        } else {
            $this->PackageSize = $packageSize;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllLocations_Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
