<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllGPSRouteVehicles.Options StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAllGPSRouteVehicles.Options
 * @subpackage Structs
 */
class GetAllGPSRouteVehicles_Options extends WebServiceRequestOptions
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The EffectiveFrom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveFrom;
    /**
     * The EffectiveTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveTo;
    /**
     * The OperatorGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OperatorGuid;
    /**
     * The PermanentChanges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PermanentChanges;
    /**
     * The Retired
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Retired;
    /**
     * The RetiredFrom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RetiredFrom;
    /**
     * The RetiredTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RetiredTo;
    /**
     * The RouteGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RouteGuid;
    /**
     * The Substitutions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Substitutions;
    /**
     * Constructor method for GetAllGPSRouteVehicles.Options
     * @uses GetAllGPSRouteVehicles_Options::setActive()
     * @uses GetAllGPSRouteVehicles_Options::setEffectiveFrom()
     * @uses GetAllGPSRouteVehicles_Options::setEffectiveTo()
     * @uses GetAllGPSRouteVehicles_Options::setOperatorGuid()
     * @uses GetAllGPSRouteVehicles_Options::setPermanentChanges()
     * @uses GetAllGPSRouteVehicles_Options::setRetired()
     * @uses GetAllGPSRouteVehicles_Options::setRetiredFrom()
     * @uses GetAllGPSRouteVehicles_Options::setRetiredTo()
     * @uses GetAllGPSRouteVehicles_Options::setRouteGuid()
     * @uses GetAllGPSRouteVehicles_Options::setSubstitutions()
     * @param bool $active
     * @param string $effectiveFrom
     * @param string $effectiveTo
     * @param string $operatorGuid
     * @param bool $permanentChanges
     * @param bool $retired
     * @param string $retiredFrom
     * @param string $retiredTo
     * @param string $routeGuid
     * @param bool $substitutions
     */
    public function __construct($active = null, $effectiveFrom = null, $effectiveTo = null, $operatorGuid = null, $permanentChanges = null, $retired = null, $retiredFrom = null, $retiredTo = null, $routeGuid = null, $substitutions = null)
    {
        $this
            ->setActive($active)
            ->setEffectiveFrom($effectiveFrom)
            ->setEffectiveTo($effectiveTo)
            ->setOperatorGuid($operatorGuid)
            ->setPermanentChanges($permanentChanges)
            ->setRetired($retired)
            ->setRetiredFrom($retiredFrom)
            ->setRetiredTo($retiredTo)
            ->setRouteGuid($routeGuid)
            ->setSubstitutions($substitutions);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\GetAllGPSRouteVehicles_Options
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get EffectiveFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveFrom()
    {
        return isset($this->EffectiveFrom) ? $this->EffectiveFrom : null;
    }
    /**
     * Set EffectiveFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveFrom
     * @return \StructType\GetAllGPSRouteVehicles_Options
     */
    public function setEffectiveFrom($effectiveFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveFrom) && !is_string($effectiveFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveFrom)), __LINE__);
        }
        if (is_null($effectiveFrom) || (is_array($effectiveFrom) && empty($effectiveFrom))) {
            unset($this->EffectiveFrom);
        } else {
            $this->EffectiveFrom = $effectiveFrom;
        }
        return $this;
    }
    /**
     * Get EffectiveTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveTo()
    {
        return isset($this->EffectiveTo) ? $this->EffectiveTo : null;
    }
    /**
     * Set EffectiveTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveTo
     * @return \StructType\GetAllGPSRouteVehicles_Options
     */
    public function setEffectiveTo($effectiveTo = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveTo) && !is_string($effectiveTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveTo)), __LINE__);
        }
        if (is_null($effectiveTo) || (is_array($effectiveTo) && empty($effectiveTo))) {
            unset($this->EffectiveTo);
        } else {
            $this->EffectiveTo = $effectiveTo;
        }
        return $this;
    }
    /**
     * Get OperatorGuid value
     * @return string|null
     */
    public function getOperatorGuid()
    {
        return $this->OperatorGuid;
    }
    /**
     * Set OperatorGuid value
     * @param string $operatorGuid
     * @return \StructType\GetAllGPSRouteVehicles_Options
     */
    public function setOperatorGuid($operatorGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($operatorGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $operatorGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($operatorGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operatorGuid) && !is_string($operatorGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatorGuid)), __LINE__);
        }
        $this->OperatorGuid = $operatorGuid;
        return $this;
    }
    /**
     * Get PermanentChanges value
     * @return bool|null
     */
    public function getPermanentChanges()
    {
        return $this->PermanentChanges;
    }
    /**
     * Set PermanentChanges value
     * @param bool $permanentChanges
     * @return \StructType\GetAllGPSRouteVehicles_Options
     */
    public function setPermanentChanges($permanentChanges = null)
    {
        // validation for constraint: boolean
        if (!is_null($permanentChanges) && !is_bool($permanentChanges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($permanentChanges)), __LINE__);
        }
        $this->PermanentChanges = $permanentChanges;
        return $this;
    }
    /**
     * Get Retired value
     * @return bool|null
     */
    public function getRetired()
    {
        return $this->Retired;
    }
    /**
     * Set Retired value
     * @param bool $retired
     * @return \StructType\GetAllGPSRouteVehicles_Options
     */
    public function setRetired($retired = null)
    {
        // validation for constraint: boolean
        if (!is_null($retired) && !is_bool($retired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retired)), __LINE__);
        }
        $this->Retired = $retired;
        return $this;
    }
    /**
     * Get RetiredFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRetiredFrom()
    {
        return isset($this->RetiredFrom) ? $this->RetiredFrom : null;
    }
    /**
     * Set RetiredFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $retiredFrom
     * @return \StructType\GetAllGPSRouteVehicles_Options
     */
    public function setRetiredFrom($retiredFrom = null)
    {
        // validation for constraint: string
        if (!is_null($retiredFrom) && !is_string($retiredFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retiredFrom)), __LINE__);
        }
        if (is_null($retiredFrom) || (is_array($retiredFrom) && empty($retiredFrom))) {
            unset($this->RetiredFrom);
        } else {
            $this->RetiredFrom = $retiredFrom;
        }
        return $this;
    }
    /**
     * Get RetiredTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRetiredTo()
    {
        return isset($this->RetiredTo) ? $this->RetiredTo : null;
    }
    /**
     * Set RetiredTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $retiredTo
     * @return \StructType\GetAllGPSRouteVehicles_Options
     */
    public function setRetiredTo($retiredTo = null)
    {
        // validation for constraint: string
        if (!is_null($retiredTo) && !is_string($retiredTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retiredTo)), __LINE__);
        }
        if (is_null($retiredTo) || (is_array($retiredTo) && empty($retiredTo))) {
            unset($this->RetiredTo);
        } else {
            $this->RetiredTo = $retiredTo;
        }
        return $this;
    }
    /**
     * Get RouteGuid value
     * @return string|null
     */
    public function getRouteGuid()
    {
        return $this->RouteGuid;
    }
    /**
     * Set RouteGuid value
     * @param string $routeGuid
     * @return \StructType\GetAllGPSRouteVehicles_Options
     */
    public function setRouteGuid($routeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($routeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $routeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($routeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routeGuid) && !is_string($routeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeGuid)), __LINE__);
        }
        $this->RouteGuid = $routeGuid;
        return $this;
    }
    /**
     * Get Substitutions value
     * @return bool|null
     */
    public function getSubstitutions()
    {
        return $this->Substitutions;
    }
    /**
     * Set Substitutions value
     * @param bool $substitutions
     * @return \StructType\GetAllGPSRouteVehicles_Options
     */
    public function setSubstitutions($substitutions = null)
    {
        // validation for constraint: boolean
        if (!is_null($substitutions) && !is_bool($substitutions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($substitutions)), __LINE__);
        }
        $this->Substitutions = $substitutions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllGPSRouteVehicles_Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
