<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllExceptionBoundaryGrades.Options StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAllExceptionBoundaryGrades.Options
 * @subpackage Structs
 */
class GetAllExceptionBoundaryGrades_Options extends WebServiceRequestOptions
{
    /**
     * The LastExceptionBoundaryGradeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastExceptionBoundaryGradeGuid;
    /**
     * The PackageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PackageSize;
    /**
     * Constructor method for GetAllExceptionBoundaryGrades.Options
     * @uses GetAllExceptionBoundaryGrades_Options::setLastExceptionBoundaryGradeGuid()
     * @uses GetAllExceptionBoundaryGrades_Options::setPackageSize()
     * @param string $lastExceptionBoundaryGradeGuid
     * @param int $packageSize
     */
    public function __construct($lastExceptionBoundaryGradeGuid = null, $packageSize = null)
    {
        $this
            ->setLastExceptionBoundaryGradeGuid($lastExceptionBoundaryGradeGuid)
            ->setPackageSize($packageSize);
    }
    /**
     * Get LastExceptionBoundaryGradeGuid value
     * @return string|null
     */
    public function getLastExceptionBoundaryGradeGuid()
    {
        return $this->LastExceptionBoundaryGradeGuid;
    }
    /**
     * Set LastExceptionBoundaryGradeGuid value
     * @param string $lastExceptionBoundaryGradeGuid
     * @return \StructType\GetAllExceptionBoundaryGrades_Options
     */
    public function setLastExceptionBoundaryGradeGuid($lastExceptionBoundaryGradeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($lastExceptionBoundaryGradeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastExceptionBoundaryGradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($lastExceptionBoundaryGradeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastExceptionBoundaryGradeGuid) && !is_string($lastExceptionBoundaryGradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastExceptionBoundaryGradeGuid)), __LINE__);
        }
        $this->LastExceptionBoundaryGradeGuid = $lastExceptionBoundaryGradeGuid;
        return $this;
    }
    /**
     * Get PackageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPackageSize()
    {
        return isset($this->PackageSize) ? $this->PackageSize : null;
    }
    /**
     * Set PackageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $packageSize
     * @return \StructType\GetAllExceptionBoundaryGrades_Options
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !is_numeric($packageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageSize)), __LINE__);
        }
        if (is_null($packageSize) || (is_array($packageSize) && empty($packageSize))) {
            unset($this->PackageSize);
        } else {
            $this->PackageSize = $packageSize;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllExceptionBoundaryGrades_Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
