<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllAddresses.Options StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAllAddresses.Options
 * @subpackage Structs
 */
class GetAllAddresses_Options extends WebServiceRequestOptions
{
    /**
     * The AddressTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddressTypeGuid;
    /**
     * The IncludeSpatialData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeSpatialData;
    /**
     * The LastAddressGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastAddressGuid;
    /**
     * The Layer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Layer;
    /**
     * The PackageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PackageSize;
    /**
     * Constructor method for GetAllAddresses.Options
     * @uses GetAllAddresses_Options::setAddressTypeGuid()
     * @uses GetAllAddresses_Options::setIncludeSpatialData()
     * @uses GetAllAddresses_Options::setLastAddressGuid()
     * @uses GetAllAddresses_Options::setLayer()
     * @uses GetAllAddresses_Options::setPackageSize()
     * @param string $addressTypeGuid
     * @param bool $includeSpatialData
     * @param string $lastAddressGuid
     * @param int $layer
     * @param int $packageSize
     */
    public function __construct($addressTypeGuid = null, $includeSpatialData = null, $lastAddressGuid = null, $layer = null, $packageSize = null)
    {
        $this
            ->setAddressTypeGuid($addressTypeGuid)
            ->setIncludeSpatialData($includeSpatialData)
            ->setLastAddressGuid($lastAddressGuid)
            ->setLayer($layer)
            ->setPackageSize($packageSize);
    }
    /**
     * Get AddressTypeGuid value
     * @return string|null
     */
    public function getAddressTypeGuid()
    {
        return $this->AddressTypeGuid;
    }
    /**
     * Set AddressTypeGuid value
     * @param string $addressTypeGuid
     * @return \StructType\GetAllAddresses_Options
     */
    public function setAddressTypeGuid($addressTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addressTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addressTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($addressTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressTypeGuid) && !is_string($addressTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressTypeGuid)), __LINE__);
        }
        $this->AddressTypeGuid = $addressTypeGuid;
        return $this;
    }
    /**
     * Get IncludeSpatialData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeSpatialData()
    {
        return isset($this->IncludeSpatialData) ? $this->IncludeSpatialData : null;
    }
    /**
     * Set IncludeSpatialData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeSpatialData
     * @return \StructType\GetAllAddresses_Options
     */
    public function setIncludeSpatialData($includeSpatialData = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSpatialData) && !is_bool($includeSpatialData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeSpatialData)), __LINE__);
        }
        if (is_null($includeSpatialData) || (is_array($includeSpatialData) && empty($includeSpatialData))) {
            unset($this->IncludeSpatialData);
        } else {
            $this->IncludeSpatialData = $includeSpatialData;
        }
        return $this;
    }
    /**
     * Get LastAddressGuid value
     * @return string|null
     */
    public function getLastAddressGuid()
    {
        return $this->LastAddressGuid;
    }
    /**
     * Set LastAddressGuid value
     * @param string $lastAddressGuid
     * @return \StructType\GetAllAddresses_Options
     */
    public function setLastAddressGuid($lastAddressGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($lastAddressGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastAddressGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($lastAddressGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastAddressGuid) && !is_string($lastAddressGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastAddressGuid)), __LINE__);
        }
        $this->LastAddressGuid = $lastAddressGuid;
        return $this;
    }
    /**
     * Get Layer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLayer()
    {
        return isset($this->Layer) ? $this->Layer : null;
    }
    /**
     * Set Layer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $layer
     * @return \StructType\GetAllAddresses_Options
     */
    public function setLayer($layer = null)
    {
        // validation for constraint: int
        if (!is_null($layer) && !is_numeric($layer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($layer)), __LINE__);
        }
        if (is_null($layer) || (is_array($layer) && empty($layer))) {
            unset($this->Layer);
        } else {
            $this->Layer = $layer;
        }
        return $this;
    }
    /**
     * Get PackageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPackageSize()
    {
        return isset($this->PackageSize) ? $this->PackageSize : null;
    }
    /**
     * Set PackageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $packageSize
     * @return \StructType\GetAllAddresses_Options
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !is_numeric($packageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageSize)), __LINE__);
        }
        if (is_null($packageSize) || (is_array($packageSize) && empty($packageSize))) {
            unset($this->PackageSize);
        } else {
            $this->PackageSize = $packageSize;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllAddresses_Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
