<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Frequency StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Frequency
 * @subpackage Structs
 */
class Frequency extends AbstractStructBase
{
    /**
     * The FrequencyString
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FrequencyString;
    /**
     * The FrequencyValue
     * @var int
     */
    public $FrequencyValue;
    /**
     * Constructor method for Frequency
     * @uses Frequency::setFrequencyString()
     * @uses Frequency::setFrequencyValue()
     * @param string $frequencyString
     * @param int $frequencyValue
     */
    public function __construct($frequencyString = null, $frequencyValue = null)
    {
        $this
            ->setFrequencyString($frequencyString)
            ->setFrequencyValue($frequencyValue);
    }
    /**
     * Get FrequencyString value
     * @return string|null
     */
    public function getFrequencyString()
    {
        return $this->FrequencyString;
    }
    /**
     * Set FrequencyString value
     * @param string $frequencyString
     * @return \StructType\Frequency
     */
    public function setFrequencyString($frequencyString = null)
    {
        // validation for constraint: string
        if (!is_null($frequencyString) && !is_string($frequencyString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($frequencyString)), __LINE__);
        }
        $this->FrequencyString = $frequencyString;
        return $this;
    }
    /**
     * Get FrequencyValue value
     * @return int|null
     */
    public function getFrequencyValue()
    {
        return $this->FrequencyValue;
    }
    /**
     * Set FrequencyValue value
     * @param int $frequencyValue
     * @return \StructType\Frequency
     */
    public function setFrequencyValue($frequencyValue = null)
    {
        // validation for constraint: int
        if (!is_null($frequencyValue) && !is_numeric($frequencyValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($frequencyValue)), __LINE__);
        }
        $this->FrequencyValue = $frequencyValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Frequency
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
